package com.xforceplus.testoqs202.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testoqs202.entity.RedLetterClaimPoolDetails;
import com.xforceplus.testoqs202.service.IRedLetterClaimPoolDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-08
 */
@RestController
public class RedLetterClaimPoolDetailsController {

  @Autowired
  private IRedLetterClaimPoolDetailsService redLetterClaimPoolDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLetterClaimPoolDetails ${table.comment}
   * @return
   */
  @GetMapping("/redletterclaimpooldetailss" )
  public XfR getRedLetterClaimPoolDetailss(XfPage page, RedLetterClaimPoolDetails redLetterClaimPoolDetails) {
    return XfR.ok(redLetterClaimPoolDetailsServiceImpl.page(page, Wrappers.query(redLetterClaimPoolDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redletterclaimpooldetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLetterClaimPoolDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLetterClaimPoolDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/redletterclaimpooldetailss")
  public XfR save(@RequestBody RedLetterClaimPoolDetails redLetterClaimPoolDetails) {
     return XfR.ok(redLetterClaimPoolDetailsServiceImpl.save(redLetterClaimPoolDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLetterClaimPoolDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/redletterclaimpooldetailss/{id}")
  public XfR putUpdate(@RequestBody RedLetterClaimPoolDetails redLetterClaimPoolDetails,@PathVariable Long id) {
      redLetterClaimPoolDetails.setId(id);
      return XfR.ok(redLetterClaimPoolDetailsServiceImpl.updateById(redLetterClaimPoolDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLetterClaimPoolDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redletterclaimpooldetailss/{id}")
  public XfR patchUpdate(@RequestBody RedLetterClaimPoolDetails redLetterClaimPoolDetails,@PathVariable Long id) {
      RedLetterClaimPoolDetails upredLetterClaimPoolDetails = redLetterClaimPoolDetailsServiceImpl.getById(id);
      if(upredLetterClaimPoolDetails != null){
        upredLetterClaimPoolDetails = ObjectCopyUtils.copyProperties(redLetterClaimPoolDetails,upredLetterClaimPoolDetails,true);
      }
      return XfR.ok(redLetterClaimPoolDetailsServiceImpl.updateById(upredLetterClaimPoolDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redletterclaimpooldetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLetterClaimPoolDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/redletterclaimpooldetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letter_claim_pool_details");
     params.put("request", condition);

     return XfR.ok(redLetterClaimPoolDetailsServiceImpl.querys(params));
  }

}
