package com.xforceplus.testoqs202.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testoqs202.entity.ExamineManage;
import com.xforceplus.testoqs202.service.IExamineManageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-06
 */
@RestController
public class ExamineManageController {

  @Autowired
  private IExamineManageService examineManageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param examineManage ${table.comment}
   * @return
   */
  @GetMapping("/examinemanages" )
  public XfR getExamineManages(XfPage page, ExamineManage examineManage) {
    return XfR.ok(examineManageServiceImpl.page(page, Wrappers.query(examineManage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/examinemanages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(examineManageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param examineManage ${table.comment}
   * @return XfR
   */
  @PostMapping("/examinemanages")
  public XfR save(@RequestBody ExamineManage examineManage) {
     return XfR.ok(examineManageServiceImpl.save(examineManage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param examineManage ${table.comment}
   * @return XfR
   */
  @PutMapping("/examinemanages/{id}")
  public XfR putUpdate(@RequestBody ExamineManage examineManage,@PathVariable Long id) {
      examineManage.setId(id);
      return XfR.ok(examineManageServiceImpl.updateById(examineManage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param examineManage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/examinemanages/{id}")
  public XfR patchUpdate(@RequestBody ExamineManage examineManage,@PathVariable Long id) {
      ExamineManage upexamineManage = examineManageServiceImpl.getById(id);
      if(upexamineManage != null){
        upexamineManage = ObjectCopyUtils.copyProperties(examineManage,upexamineManage,true);
      }
      return XfR.ok(examineManageServiceImpl.updateById(upexamineManage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/examinemanages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(examineManageServiceImpl.removeById(id));
  }

  @PostMapping("/examinemanages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "examine_manage");
     params.put("request", condition);

     return XfR.ok(examineManageServiceImpl.querys(params));
  }

}
