package com.xforceplus.testoqs202.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testoqs202.entity.InventoryDetail;
import com.xforceplus.testoqs202.service.IInventoryDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 库存记录前端控制器
 *
 * @author ultraman
 * @date 2023-07-06
 */
@RestController
public class InventoryDetailController {

  @Autowired
  private IInventoryDetailService inventoryDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventoryDetail 库存记录
   * @return
   */
  @GetMapping("/inventorydetails" )
  public XfR getInventoryDetails(XfPage page, InventoryDetail inventoryDetail) {
    return XfR.ok(inventoryDetailServiceImpl.page(page, Wrappers.query(inventoryDetail)));
  }

  /**
   * 通过id查询库存记录
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventorydetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryDetailServiceImpl.getById(id));
  }

  /**
   * 新增库存记录
   * @param inventoryDetail 库存记录
   * @return XfR
   */
  @PostMapping("/inventorydetails")
  public XfR save(@RequestBody InventoryDetail inventoryDetail) {
     return XfR.ok(inventoryDetailServiceImpl.save(inventoryDetail));
  }

  /**
   * 修改-传入修改后的全部数据库存记录
   * @param inventoryDetail 库存记录
   * @return XfR
   */
  @PutMapping("/inventorydetails/{id}")
  public XfR putUpdate(@RequestBody InventoryDetail inventoryDetail,@PathVariable Long id) {
      inventoryDetail.setId(id);
      return XfR.ok(inventoryDetailServiceImpl.updateById(inventoryDetail));
  }

  /**
   * 修改-传入修改的数据库存记录
   * @param inventoryDetail 库存记录
   * @return XfR
   */
  @PatchMapping("/inventorydetails/{id}")
  public XfR patchUpdate(@RequestBody InventoryDetail inventoryDetail,@PathVariable Long id) {
      InventoryDetail upinventoryDetail = inventoryDetailServiceImpl.getById(id);
      if(upinventoryDetail != null){
        upinventoryDetail = ObjectCopyUtils.copyProperties(inventoryDetail,upinventoryDetail,true);
      }
      return XfR.ok(inventoryDetailServiceImpl.updateById(upinventoryDetail));
  }

  /**
   * 通过id删除库存记录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventorydetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryDetailServiceImpl.removeById(id));
  }

  @PostMapping("/inventorydetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inventory_detail");
     params.put("request", condition);

     return XfR.ok(inventoryDetailServiceImpl.querys(params));
  }

}
