package com.xforceplus.testoqs202.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testoqs202.entity.RedLetterClaimPool;
import com.xforceplus.testoqs202.service.IRedLetterClaimPoolService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-06
 */
@RestController
public class RedLetterClaimPoolController {

  @Autowired
  private IRedLetterClaimPoolService redLetterClaimPoolServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLetterClaimPool ${table.comment}
   * @return
   */
  @GetMapping("/redletterclaimpools" )
  public XfR getRedLetterClaimPools(XfPage page, RedLetterClaimPool redLetterClaimPool) {
    return XfR.ok(redLetterClaimPoolServiceImpl.page(page, Wrappers.query(redLetterClaimPool)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redletterclaimpools/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLetterClaimPoolServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLetterClaimPool ${table.comment}
   * @return XfR
   */
  @PostMapping("/redletterclaimpools")
  public XfR save(@RequestBody RedLetterClaimPool redLetterClaimPool) {
     return XfR.ok(redLetterClaimPoolServiceImpl.save(redLetterClaimPool));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLetterClaimPool ${table.comment}
   * @return XfR
   */
  @PutMapping("/redletterclaimpools/{id}")
  public XfR putUpdate(@RequestBody RedLetterClaimPool redLetterClaimPool,@PathVariable Long id) {
      redLetterClaimPool.setId(id);
      return XfR.ok(redLetterClaimPoolServiceImpl.updateById(redLetterClaimPool));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLetterClaimPool ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redletterclaimpools/{id}")
  public XfR patchUpdate(@RequestBody RedLetterClaimPool redLetterClaimPool,@PathVariable Long id) {
      RedLetterClaimPool upredLetterClaimPool = redLetterClaimPoolServiceImpl.getById(id);
      if(upredLetterClaimPool != null){
        upredLetterClaimPool = ObjectCopyUtils.copyProperties(redLetterClaimPool,upredLetterClaimPool,true);
      }
      return XfR.ok(redLetterClaimPoolServiceImpl.updateById(upredLetterClaimPool));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redletterclaimpools/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLetterClaimPoolServiceImpl.removeById(id));
  }

  @PostMapping("/redletterclaimpools/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letter_claim_pool");
     params.put("request", condition);

     return XfR.ok(redLetterClaimPoolServiceImpl.querys(params));
  }

}
