package com.xforceplus.testoqs202.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testoqs202.entity.Three0608001;
import com.xforceplus.testoqs202.service.IThree0608001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * three0608001前端控制器
 *
 * @author ultraman
 * @date 2023-07-06
 */
@RestController
public class Three0608001Controller {

  @Autowired
  private IThree0608001Service three0608001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param three0608001 three0608001
   * @return
   */
  @GetMapping("/three0608001s" )
  public XfR getThree0608001s(XfPage page, Three0608001 three0608001) {
    return XfR.ok(three0608001ServiceImpl.page(page, Wrappers.query(three0608001)));
  }

  /**
   * 通过id查询three0608001
   * @param  id
   * @return XfR
   */
  @GetMapping("/three0608001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(three0608001ServiceImpl.getById(id));
  }

  /**
   * 新增three0608001
   * @param three0608001 three0608001
   * @return XfR
   */
  @PostMapping("/three0608001s")
  public XfR save(@RequestBody Three0608001 three0608001) {
     return XfR.ok(three0608001ServiceImpl.save(three0608001));
  }

  /**
   * 修改-传入修改后的全部数据three0608001
   * @param three0608001 three0608001
   * @return XfR
   */
  @PutMapping("/three0608001s/{id}")
  public XfR putUpdate(@RequestBody Three0608001 three0608001,@PathVariable Long id) {
      three0608001.setId(id);
      return XfR.ok(three0608001ServiceImpl.updateById(three0608001));
  }

  /**
   * 修改-传入修改的数据three0608001
   * @param three0608001 three0608001
   * @return XfR
   */
  @PatchMapping("/three0608001s/{id}")
  public XfR patchUpdate(@RequestBody Three0608001 three0608001,@PathVariable Long id) {
      Three0608001 upthree0608001 = three0608001ServiceImpl.getById(id);
      if(upthree0608001 != null){
        upthree0608001 = ObjectCopyUtils.copyProperties(three0608001,upthree0608001,true);
      }
      return XfR.ok(three0608001ServiceImpl.updateById(upthree0608001));
  }

  /**
   * 通过id删除three0608001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/three0608001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(three0608001ServiceImpl.removeById(id));
  }

  @PostMapping("/three0608001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "three0608001");
     params.put("request", condition);

     return XfR.ok(three0608001ServiceImpl.querys(params));
  }

}
