package com.xforceplus.testoqs202.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testoqs202.entity.Two0608001;
import com.xforceplus.testoqs202.service.ITwo0608001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * two0608001前端控制器
 *
 * @author ultraman
 * @date 2023-07-06
 */
@RestController
public class Two0608001Controller {

  @Autowired
  private ITwo0608001Service two0608001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param two0608001 two0608001
   * @return
   */
  @GetMapping("/two0608001s" )
  public XfR getTwo0608001s(XfPage page, Two0608001 two0608001) {
    return XfR.ok(two0608001ServiceImpl.page(page, Wrappers.query(two0608001)));
  }

  /**
   * 通过id查询two0608001
   * @param  id
   * @return XfR
   */
  @GetMapping("/two0608001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(two0608001ServiceImpl.getById(id));
  }

  /**
   * 新增two0608001
   * @param two0608001 two0608001
   * @return XfR
   */
  @PostMapping("/two0608001s")
  public XfR save(@RequestBody Two0608001 two0608001) {
     return XfR.ok(two0608001ServiceImpl.save(two0608001));
  }

  /**
   * 修改-传入修改后的全部数据two0608001
   * @param two0608001 two0608001
   * @return XfR
   */
  @PutMapping("/two0608001s/{id}")
  public XfR putUpdate(@RequestBody Two0608001 two0608001,@PathVariable Long id) {
      two0608001.setId(id);
      return XfR.ok(two0608001ServiceImpl.updateById(two0608001));
  }

  /**
   * 修改-传入修改的数据two0608001
   * @param two0608001 two0608001
   * @return XfR
   */
  @PatchMapping("/two0608001s/{id}")
  public XfR patchUpdate(@RequestBody Two0608001 two0608001,@PathVariable Long id) {
      Two0608001 uptwo0608001 = two0608001ServiceImpl.getById(id);
      if(uptwo0608001 != null){
        uptwo0608001 = ObjectCopyUtils.copyProperties(two0608001,uptwo0608001,true);
      }
      return XfR.ok(two0608001ServiceImpl.updateById(uptwo0608001));
  }

  /**
   * 通过id删除two0608001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/two0608001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(two0608001ServiceImpl.removeById(id));
  }

  @PostMapping("/two0608001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "two0608001");
     params.put("request", condition);

     return XfR.ok(two0608001ServiceImpl.querys(params));
  }

}
