package com.xforceplus.tke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票登记表状态
 * </p>
 *
 * @author ultraman
 * @since 2022-03-30
 */
public enum InvoiceStatus {

    _2("2", "已配单"),
    _3("3", "已寄送"),
    _4("4", "已签核"),
    _5("5", "已退回"),
    _6("6", "已记账"),
    _7("7", "已支付");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatus fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
