package com.xforceplus.tke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款单状态
 * </p>
 *
 * @author ultraman
 * @since 2022-03-30
 */
public enum PaymentStatus {

    _0("0", "草稿"),
    _1("1", "待线下审批"),
    _2("2", "待分公司确认"),
    _3("3", "待区域财务提交"),
    _4("4", "待总部财务提交"),
    _5("5", "已提交待支付"),
    _100("100", "已支付"),
    _102("102", "已冲销"),
    _101("101", "提交失败"),
    _103("103", "驳回");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PaymentStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "100":
                return _100;
            case "102":
                return _102;
            case "101":
                return _101;
            case "103":
                return _103;
            default:
                return null;
        }
    }
}
