package com.xforceplus.tke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 采购订单类型
 * </p>
 *
 * @author ultraman
 * @since 2022-03-30
 */
public enum PurchaseOrderType {

    _0("0", "常规订单"),
    _45("45", "框架采购订单"),
    _99("99", "虚拟采购订单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PurchaseOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurchaseOrderType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "45":
                return _45;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
