package com.xforceplus.tke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-03-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceRegistrationSheet implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 供应商代码
   */
  @TableField("vendorID")
  private String vendorID;

  /**
   * 分公司代码
   */
  @TableField("branchID")
  private String branchID;

  /**
   * PO
   */
  @TableField("purchaseOrder")
  private String purchaseOrder;

  /**
   * 快递单号
   */
  @TableField("expressNumber")
  private String expressNumber;

  /**
   * 发票金额
   */
  @TableField("invoiceAmountWithTax")
  private String invoiceAmountWithTax;

  /**
   * 已支付金额
   */
  @TableField("requestPayAmount")
  private String requestPayAmount;

  /**
   * 付款基准日
   */
  @TableField("paymentBaseDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentBaseDate;

  /**
   * 认证状态
   */
  @TableField("authenticateStatus")
  private String authenticateStatus;

  /**
   * 认证日期
   */
  @TableField("authenticateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authenticateDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 票据类型
   */
  @TableField("receiptType")
  private String receiptType;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private String taxAmount;

  /**
   * 供应商名称
   */
  @TableField("vendorName")
  private String vendorName;

  /**
   * 分公司名称
   */
  @TableField("branchName")
  private String branchName;

  /**
   * 付款单号
   */
  @TableField("apID")
  private String apID;

  /**
   * 开票日期
   */
  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  /**
   * 收票日期
   */
  @TableField("receiveInvoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiveInvoiceDate;

  /**
   * 序列号
   */
  @TableField("invoiceId")
  private String invoiceId;

  /**
   * 发票寄送日期
   */
  @TableField("invoiceSendDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceSendDate;

  /**
   * 支付凭证号
   */
  @TableField("payedVoucherID")
  private String payedVoucherID;

  /**
   * 寄送次数
   */
  @TableField("sendNum")
  private Long sendNum;

  /**
   * 退回次数
   */
  @TableField("returnNum")
  private Long returnNum;

  /**
   * 未支付金额
   */
  @TableField("unpayedAmount")
  private String unpayedAmount;

  /**
   * 发票业务状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 发票影像
   */
  @TableField("invoiceImage")
  private String invoiceImage;

  /**
   * 红字发票代码
   */
  @TableField("redInvoiceCode")
  private String redInvoiceCode;

  /**
   * 红字发票号码
   */
  @TableField("redInvoiceNo")
  private String redInvoiceNo;

  /**
   * 红字发票影像
   */
  @TableField("redInvoiceImage")
  private String redInvoiceImage;

  /**
   * 红字发票金额
   */
  @TableField("redInvoiceAmount")
  private String redInvoiceAmount;

  /**
   * 采购组
   */
  @TableField("purchasingTeam")
  private String purchasingTeam;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("vendorID", vendorID);
      map.put("branchID", branchID);
      map.put("purchaseOrder", purchaseOrder);
      map.put("expressNumber", expressNumber);
      map.put("invoiceAmountWithTax", invoiceAmountWithTax);
      map.put("requestPayAmount", requestPayAmount);
      map.put("paymentBaseDate", BocpGenUtils.toTimestamp(paymentBaseDate));
      map.put("authenticateStatus", authenticateStatus);
      map.put("authenticateDate", BocpGenUtils.toTimestamp(authenticateDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("receiptType", receiptType);
      map.put("taxAmount", taxAmount);
      map.put("vendorName", vendorName);
      map.put("branchName", branchName);
      map.put("apID", apID);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("receiveInvoiceDate", BocpGenUtils.toTimestamp(receiveInvoiceDate));
      map.put("invoiceId", invoiceId);
      map.put("invoiceSendDate", BocpGenUtils.toTimestamp(invoiceSendDate));
      map.put("payedVoucherID", payedVoucherID);
      map.put("sendNum", sendNum);
      map.put("returnNum", returnNum);
      map.put("unpayedAmount", unpayedAmount);
      map.put("invoiceStatus", invoiceStatus);
      map.put("invoiceImage", invoiceImage);
      map.put("redInvoiceCode", redInvoiceCode);
      map.put("redInvoiceNo", redInvoiceNo);
      map.put("redInvoiceImage", redInvoiceImage);
      map.put("redInvoiceAmount", redInvoiceAmount);
      map.put("purchasingTeam", purchasingTeam);
      return map;
  }

  public static InvoiceRegistrationSheet fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceRegistrationSheet entity = new InvoiceRegistrationSheet();
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vendorID")) {
      Object obj = map.get("vendorID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVendorID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchID")) {
      Object obj = map.get("branchID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBranchID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrder")) {
      Object obj = map.get("purchaseOrder");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expressNumber")) {
      Object obj = map.get("expressNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestPayAmount")) {
      Object obj = map.get("requestPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentBaseDate")) {
      Object obj = map.get("paymentBaseDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentBaseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentBaseDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentBaseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentBaseDate(null);
      }
    }
    if(map.containsKey("authenticateStatus")) {
      Object obj = map.get("authenticateStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthenticateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authenticateDate")) {
      Object obj = map.get("authenticateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthenticateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthenticateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthenticateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthenticateDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiptType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vendorName")) {
      Object obj = map.get("vendorName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVendorName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchName")) {
      Object obj = map.get("branchName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBranchName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apID")) {
      Object obj = map.get("apID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("receiveInvoiceDate")) {
      Object obj = map.get("receiveInvoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiveInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiveInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiveInvoiceDate(null);
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSendDate")) {
      Object obj = map.get("invoiceSendDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceSendDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceSendDate(null);
      }
    }
    if(map.containsKey("payedVoucherID")) {
      Object obj = map.get("payedVoucherID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayedVoucherID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNum")) {
      Object obj = map.get("sendNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setSendNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSendNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("returnNum")) {
      Object obj = map.get("returnNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setReturnNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setReturnNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnpayedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceImage")) {
      Object obj = map.get("invoiceImage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceCode")) {
      Object obj = map.get("redInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceNo")) {
      Object obj = map.get("redInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceImage")) {
      Object obj = map.get("redInvoiceImage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedInvoiceImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceAmount")) {
      Object obj = map.get("redInvoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
