package com.xforceplus.tke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-03-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PaymentRequestSheet implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请ID
   */
  @TableField("rID")
  private String rID;

  /**
   * 申请人
   */
  private String applicant;

  /**
   * 本次申请支付金额
   */
  @TableField("totalAmount")
  private String totalAmount;

  /**
   * 当前审批人
   */
  private String approver;

  /**
   * 审批历史
   */
  @TableField("approvalHistory")
  private String approvalHistory;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 当前状态图标
   */
  @TableField("statusImage")
  private String statusImage;

  /**
   * 付款单类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 预付款金额
   */
  @TableField("prePayment")
  private String prePayment;

  /**
   * 付款对象
   */
  @TableField("payObject")
  private String payObject;

  /**
   * 前置业务类型
   */
  @TableField("bussinessType")
  private String bussinessType;

  /**
   * 预付类型
   */
  @TableField("paymentSubtype")
  private String paymentSubtype;

  /**
   * 订单总金额
   */
  @TableField("poTotalAmount")
  private String poTotalAmount;

  /**
   * 发票总金额
   */
  @TableField("invoiceTotalAmount")
  private String invoiceTotalAmount;

  /**
   * 本次申请实付金额
   */
  @TableField("payAmount")
  private String payAmount;

  /**
   * 历史已付金额
   */
  @TableField("payHistoryAmount")
  private String payHistoryAmount;

  /**
   * 附件
   */
  private String attachment;

  /**
   * 预付款凭证号
   */
  @TableField("prepaymentVoucherNo")
  private String prepaymentVoucherNo;

  /**
   * 应付款凭证号
   */
  @TableField("paymentVoucherNo")
  private String paymentVoucherNo;

  /**
   * 下载者
   */
  private String downloader;

  /**
   * 下载状态
   */
  @TableField("downloadStatus")
  private Boolean downloadStatus;

  /**
   * 当前状态
   */
  private String status;

  /**
   * 付款对象ID
   */
  @TableField("payObjectID")
  private String payObjectID;

  /**
   * 付款银行类型
   */
  @TableField("payBank")
  private String payBank;

  /**
   * 收款银行
   */
  @TableField("receiveBank")
  private String receiveBank;

  /**
   * 文本
   */
  private String text;

  /**
   * 付款备注
   */
  private String remark;

  /**
   * 代理费类型
   */
  @TableField("agentFeeType")
  private String agentFeeType;

  /**
   * 付款到期日
   */
  @TableField("dueDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dueDate;

  /**
   * 异常信息
   */
  @TableField("errorMsg")
  private String errorMsg;

  /**
   * 利润中心
   */
  @TableField("profitCenter")
  private String profitCenter;

  /**
   * 开户行
   */
  @TableField("bankAccount")
  private String bankAccount;

  /**
   * 户名
   */
  @TableField("accountName")
  private String accountName;

  /**
   * 创建日期
   */
  @TableField("createDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createDate;

  /**
   * 过账日期
   */
  @TableField("sendSAPDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sendSAPDate;

  /**
   * 实际付款日期
   */
  @TableField("realPayDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime realPayDate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("rID", rID);
      map.put("applicant", applicant);
      map.put("totalAmount", totalAmount);
      map.put("approver", approver);
      map.put("approvalHistory", approvalHistory);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("statusImage", statusImage);
      map.put("paymentType", paymentType);
      map.put("prePayment", prePayment);
      map.put("payObject", payObject);
      map.put("bussinessType", bussinessType);
      map.put("paymentSubtype", paymentSubtype);
      map.put("poTotalAmount", poTotalAmount);
      map.put("invoiceTotalAmount", invoiceTotalAmount);
      map.put("payAmount", payAmount);
      map.put("payHistoryAmount", payHistoryAmount);
      map.put("attachment", attachment);
      map.put("prepaymentVoucherNo", prepaymentVoucherNo);
      map.put("paymentVoucherNo", paymentVoucherNo);
      map.put("downloader", downloader);
      map.put("downloadStatus", downloadStatus);
      map.put("status", status);
      map.put("payObjectID", payObjectID);
      map.put("payBank", payBank);
      map.put("receiveBank", receiveBank);
      map.put("text", text);
      map.put("remark", remark);
      map.put("agentFeeType", agentFeeType);
      map.put("dueDate", BocpGenUtils.toTimestamp(dueDate));
      map.put("errorMsg", errorMsg);
      map.put("profitCenter", profitCenter);
      map.put("bankAccount", bankAccount);
      map.put("accountName", accountName);
      map.put("createDate", BocpGenUtils.toTimestamp(createDate));
      map.put("sendSAPDate", BocpGenUtils.toTimestamp(sendSAPDate));
      map.put("realPayDate", BocpGenUtils.toTimestamp(realPayDate));
      return map;
  }

  public static PaymentRequestSheet fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PaymentRequestSheet entity = new PaymentRequestSheet();
    if(map.containsKey("rID")) {
      Object obj = map.get("rID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicant")) {
      Object obj = map.get("applicant");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approver")) {
      Object obj = map.get("approver");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprover((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalHistory")) {
      Object obj = map.get("approvalHistory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalHistory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statusImage")) {
      Object obj = map.get("statusImage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatusImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePayment")) {
      Object obj = map.get("prePayment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrePayment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payObject")) {
      Object obj = map.get("payObject");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayObject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussinessType")) {
      Object obj = map.get("bussinessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBussinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentSubtype")) {
      Object obj = map.get("paymentSubtype");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentSubtype((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poTotalAmount")) {
      Object obj = map.get("poTotalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTotalAmount")) {
      Object obj = map.get("invoiceTotalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payAmount")) {
      Object obj = map.get("payAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payHistoryAmount")) {
      Object obj = map.get("payHistoryAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayHistoryAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment")) {
      Object obj = map.get("attachment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentVoucherNo")) {
      Object obj = map.get("prepaymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNo")) {
      Object obj = map.get("paymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloader")) {
      Object obj = map.get("downloader");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloader((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadStatus")) {
      Object obj = map.get("downloadStatus");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setDownloadStatus((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setDownloadStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payObjectID")) {
      Object obj = map.get("payObjectID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayObjectID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payBank")) {
      Object obj = map.get("payBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveBank")) {
      Object obj = map.get("receiveBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeType")) {
      Object obj = map.get("agentFeeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentFeeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dueDate")) {
      Object obj = map.get("dueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDueDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDueDate(null);
      }
    }
    if(map.containsKey("errorMsg")) {
      Object obj = map.get("errorMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankAccount")) {
      Object obj = map.get("bankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountName")) {
      Object obj = map.get("accountName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateDate(null);
      }
    }
    if(map.containsKey("sendSAPDate")) {
      Object obj = map.get("sendSAPDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendSAPDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSendSAPDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSendSAPDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSendSAPDate(null);
      }
    }
    if(map.containsKey("realPayDate")) {
      Object obj = map.get("realPayDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRealPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRealPayDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRealPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRealPayDate(null);
      }
    }
    return entity;
  }
}
