package com.xforceplus.tocorder.controller;


/**
 * 霸王茶姬订单feign客户端
 *
 * @author ultraman
 * @date 2025-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderBwcj;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "toc-order")
public interface OrderBwcjFeignApi {

  /**
   * 通过id查询霸王茶姬订单
   * @param  id
   * @return R
   */
  @GetMapping("/orderBwcj/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增霸王茶姬订单
   * @param orderBwcj 霸王茶姬订单
   * @return R
   */
  @PostMapping("/orderBwcj/add")
  public R save(@RequestBody OrderBwcj orderBwcj);

  /**
   * 修改霸王茶姬订单
   * @param orderBwcj 霸王茶姬订单
   * @return R
   */
  @PostMapping("/orderBwcj/update")
  public R updateById(@RequestBody OrderBwcj orderBwcj);

  /**
   * 通过id删除霸王茶姬订单
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderBwcj/del/{id}" )
  public R removeById(@PathVariable Long id);

}