package com.xforceplus.tocorder.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderEleme;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "toc-order")
public interface OrderElemeFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/orderEleme/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param orderEleme ${table.comment}
   * @return R
   */
  @PostMapping("/orderEleme/add")
  public R save(@RequestBody OrderEleme orderEleme);

  /**
   * 修改${table.comment}
   * @param orderEleme ${table.comment}
   * @return R
   */
  @PostMapping("/orderEleme/update")
  public R updateById(@RequestBody OrderEleme orderEleme);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderEleme/del/{id}" )
  public R removeById(@PathVariable Long id);

}