package com.xforceplus.tocorder.controller;


/**
 * 霸王茶姬订单商品feign客户端
 *
 * @author ultraman
 * @date 2025-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderItemBwcj;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "toc-order")
public interface OrderItemBwcjFeignApi {

  /**
   * 通过id查询霸王茶姬订单商品
   * @param  id
   * @return R
   */
  @GetMapping("/orderItemBwcj/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增霸王茶姬订单商品
   * @param orderItemBwcj 霸王茶姬订单商品
   * @return R
   */
  @PostMapping("/orderItemBwcj/add")
  public R save(@RequestBody OrderItemBwcj orderItemBwcj);

  /**
   * 修改霸王茶姬订单商品
   * @param orderItemBwcj 霸王茶姬订单商品
   * @return R
   */
  @PostMapping("/orderItemBwcj/update")
  public R updateById(@RequestBody OrderItemBwcj orderItemBwcj);

  /**
   * 通过id删除霸王茶姬订单商品
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderItemBwcj/del/{id}" )
  public R removeById(@PathVariable Long id);

}