package com.xforceplus.tocorder.controller;


/**
 * 美团订单feign客户端
 *
 * @author ultraman
 * @date 2025-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderMeiTuan;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "toc-order")
public interface OrderMeiTuanFeignApi {

  /**
   * 通过id查询美团订单
   * @param  id
   * @return R
   */
  @GetMapping("/orderMeiTuan/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增美团订单
   * @param orderMeiTuan 美团订单
   * @return R
   */
  @PostMapping("/orderMeiTuan/add")
  public R save(@RequestBody OrderMeiTuan orderMeiTuan);

  /**
   * 修改美团订单
   * @param orderMeiTuan 美团订单
   * @return R
   */
  @PostMapping("/orderMeiTuan/update")
  public R updateById(@RequestBody OrderMeiTuan orderMeiTuan);

  /**
   * 通过id删除美团订单
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderMeiTuan/del/{id}" )
  public R removeById(@PathVariable Long id);

}