package com.xforceplus.tocorder.controller;


/**
 * 霸王茶姬档案文件信息feign客户端
 *
 * @author ultraman
 * @date 2025-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.TaxArchiveRecordFileBwcj;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "toc-order")
public interface TaxArchiveRecordFileBwcjFeignApi {

  /**
   * 通过id查询霸王茶姬档案文件信息
   * @param  id
   * @return R
   */
  @GetMapping("/taxArchiveRecordFileBwcj/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增霸王茶姬档案文件信息
   * @param taxArchiveRecordFileBwcj 霸王茶姬档案文件信息
   * @return R
   */
  @PostMapping("/taxArchiveRecordFileBwcj/add")
  public R save(@RequestBody TaxArchiveRecordFileBwcj taxArchiveRecordFileBwcj);

  /**
   * 修改霸王茶姬档案文件信息
   * @param taxArchiveRecordFileBwcj 霸王茶姬档案文件信息
   * @return R
   */
  @PostMapping("/taxArchiveRecordFileBwcj/update")
  public R updateById(@RequestBody TaxArchiveRecordFileBwcj taxArchiveRecordFileBwcj);

  /**
   * 通过id删除霸王茶姬档案文件信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/taxArchiveRecordFileBwcj/del/{id}" )
  public R removeById(@PathVariable Long id);

}