package com.xforceplus.tocorder.controller;


/**
 * 霸王茶姬档案信息feign客户端
 *
 * @author ultraman
 * @date 2025-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.TaxElectronicArchiveBwcj;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "toc-order")
public interface TaxElectronicArchiveBwcjFeignApi {

  /**
   * 通过id查询霸王茶姬档案信息
   * @param  id
   * @return R
   */
  @GetMapping("/taxElectronicArchiveBwcj/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增霸王茶姬档案信息
   * @param taxElectronicArchiveBwcj 霸王茶姬档案信息
   * @return R
   */
  @PostMapping("/taxElectronicArchiveBwcj/add")
  public R save(@RequestBody TaxElectronicArchiveBwcj taxElectronicArchiveBwcj);

  /**
   * 修改霸王茶姬档案信息
   * @param taxElectronicArchiveBwcj 霸王茶姬档案信息
   * @return R
   */
  @PostMapping("/taxElectronicArchiveBwcj/update")
  public R updateById(@RequestBody TaxElectronicArchiveBwcj taxElectronicArchiveBwcj);

  /**
   * 通过id删除霸王茶姬档案信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/taxElectronicArchiveBwcj/del/{id}" )
  public R removeById(@PathVariable Long id);

}