package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * eleme_invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum ElemeInvoiceType {

    PERSONAL("personal", "个人"),
    COMPANY("company", "企业");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ElemeInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ElemeInvoiceType fromCode(String code){
        switch(code) {
            case "personal":
                return PERSONAL;
            case "company":
                return COMPANY;
            default:
                return null;
        }
    }
}
