package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * eleme_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum ElemeStatus {

    PENDING("pending", "未生效订单"),
    UNPROCESSED("unprocessed", "未处理订单"),
    REFUNDING("refunding", "退单处理中"),
    VALID("valid", "已处理的有效订单"),
    INVALID("invalid", "无效订单"),
    SETTLED("settled", "已完成订单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ElemeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ElemeStatus fromCode(String code){
        switch(code) {
            case "pending":
                return PENDING;
            case "unprocessed":
                return UNPROCESSED;
            case "refunding":
                return REFUNDING;
            case "valid":
                return VALID;
            case "invalid":
                return INVALID;
            case "settled":
                return SETTLED;
            default:
                return null;
        }
    }
}
