package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * eleme_super_vip
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum ElemeSuperVip {

    NOT_VIP("NOT_VIP", "非会员"),
    ELEME_SUPER_VIP("ELEME_SUPER_VIP", "饿了么超级会员"),
    BAIDU_SUPER_VIP("BAIDU_SUPER_VIP", "饿了么星选超级会员");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ElemeSuperVip(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ElemeSuperVip fromCode(String code){
        switch(code) {
            case "NOT_VIP":
                return NOT_VIP;
            case "ELEME_SUPER_VIP":
                return ELEME_SUPER_VIP;
            case "BAIDU_SUPER_VIP":
                return BAIDU_SUPER_VIP;
            default:
                return null;
        }
    }
}
