package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jing_dong_delivery_carrier_no
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum JingDongDeliveryCarrierNo {

    _9966("9966", "达达专送"),
    _2938("2938", "商家自送"),
    _3587("3587", "同城快递"),
    _9999("9999", "到店自提");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JingDongDeliveryCarrierNo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JingDongDeliveryCarrierNo fromCode(String code){
        switch(code) {
            case "9966":
                return _9966;
            case "2938":
                return _2938;
            case "3587":
                return _3587;
            case "9999":
                return _9999;
            default:
                return null;
        }
    }
}
