package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * mei_tuan_order_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum MeiTuanOrderStatus {

    _4("4", "商家已接单"),
    _8("8", "订单已完成"),
    _9("9", "订单已取消"),
    _2("2", "用户已支付");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MeiTuanOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MeiTuanOrderStatus fromCode(String code){
        switch(code) {
            case "4":
                return _4;
            case "8":
                return _8;
            case "9":
                return _9;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
