package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * mei_tuan_package_bag_mode
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum MeiTuanPackageBagMode {

    _0("0", "按照商品餐盒费收取"),
    _1("1", "按照订单总价收取"),
    _2("2", "按照订单口袋收取");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MeiTuanPackageBagMode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MeiTuanPackageBagMode fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
