package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * record_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum RecordType {

    DART02("DART02", "税务报表（税局）"),
    DART03("DART03", "完税证明");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RecordType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecordType fromCode(String code){
        switch(code) {
            case "DART02":
                return DART02;
            case "DART03":
                return DART03;
            default:
                return null;
        }
    }
}
