package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_frequency
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum TaxFrequency {

    _0("0", "次"),
    _1("1", "季"),
    _2("2", "月"),
    _8("8", "半年"),
    _9("9", "年");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxFrequency(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxFrequency fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "8":
                return _8;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
