package com.xforceplus.tocorder.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum TaxType {

    _01("01", "增值税及附加"),
    _02("02", "企业所得税预缴"),
    _03("03", "企业所得税汇算清缴"),
    _06("06", "关联业务往来"),
    _08("08", "印花税"),
    _38("38", "财务报表"),
    _39("39", "残疾人就业保障金"),
    _40("40", "工会经费");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "06":
                return _06;
            case "08":
                return _08;
            case "38":
                return _38;
            case "39":
                return _39;
            case "40":
                return _40;
            default:
                return null;
        }
    }
}
