package com.xforceplus.tocorder.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 霸王茶姬订单
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderBwcj implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务类型
   */
  private Long bizType;

  /**
   * 订单号
   */
  private String orderNo;

  /**
   * 订单类型
   */
  private Long orderType;

  /**
   * 店内单号
   */
  private String storeOrderNo;

  /**
   * 订单来源
   */
  private Long source;

  /**
   * 来源单号
   */
  private String sourceNo;

  /**
   * 来源系统
   */
  private Long fromSystem;

  /**
   * 订单总金额
   */
  private Long totalAmount;

  /**
   * 打包费
   */
  private Long packAmount;

  /**
   * 商品总金额
   */
  private Long itemAmount;

  /**
   * 运费总金额
   */
  private Long freightAmount;

  /**
   * 优惠总金额
   */
  private Long discountAmount;

  /**
   * 实付金额
   */
  private Long actualAmount;

  /**
   * 支付金额
   */
  private Long payAmount;

  /**
   * 找零金额
   */
  private Long changeAmount;

  /**
   * 支付方式
   */
  private Long payType;

  /**
   * 结账模式
   */
  private Long payModel;

  /**
   * 支付状态
   */
  private Long payStatus;

  /**
   * 发票类型
   */
  private Long invoiceType;

  /**
   * 商品信息
   */
  private String itemInfo;

  /**
   * 折扣信息
   */
  private String discountInfo;

  /**
   * 状态
   */
  private Long status;

  /**
   * 退款状态
   */
  private Long afterSaleStatus;

  /**
   * 接单状态
   */
  private Long receiveStatus;

  /**
   * 履约状态
   */
  private Long performanceStatus;

  /**
   * 版本号
   */
  private Long version;

  /**
   * 业务子类型
   */
  private Long bizSubType;

  /**
   * 是否存在退款单
   */
  private Long refundFlag;

  /**
   * 开发票状态
   */
  private Long invoiceStatus;

  /**
   * 外部id
   */
  private Long outId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 同步标识
   */
  private Long syncFlag;

  /**
   * 删除标识
   */
  private Long isDeleted;

  /**
   * 门店id
   */
  private Long storeId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("biz_type", bizType);
      map.put("order_no", orderNo);
      map.put("order_type", orderType);
      map.put("store_order_no", storeOrderNo);
      map.put("source", source);
      map.put("source_no", sourceNo);
      map.put("from_system", fromSystem);
      map.put("total_amount", totalAmount);
      map.put("pack_amount", packAmount);
      map.put("item_amount", itemAmount);
      map.put("freight_amount", freightAmount);
      map.put("discount_amount", discountAmount);
      map.put("actual_amount", actualAmount);
      map.put("pay_amount", payAmount);
      map.put("change_amount", changeAmount);
      map.put("pay_type", payType);
      map.put("pay_model", payModel);
      map.put("pay_status", payStatus);
      map.put("invoice_type", invoiceType);
      map.put("item_info", itemInfo);
      map.put("discount_info", discountInfo);
      map.put("status", status);
      map.put("after_sale_status", afterSaleStatus);
      map.put("receive_status", receiveStatus);
      map.put("performance_status", performanceStatus);
      map.put("version", version);
      map.put("biz_sub_type", bizSubType);
      map.put("refund_flag", refundFlag);
      map.put("invoice_status", invoiceStatus);
      map.put("out_id", outId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sync_flag", syncFlag);
      map.put("is_deleted", isDeleted);
      map.put("store_id", storeId);

      return map;
  }

  public static OrderBwcj fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderBwcj entity = new OrderBwcj();
    if(map.containsKey("biz_type")) {
      Object obj = map.get("biz_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBizType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBizType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBizType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("store_order_no")) {
      Object obj = map.get("store_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSource((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSource(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSource(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("source_no")) {
      Object obj = map.get("source_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("from_system")) {
      Object obj = map.get("from_system");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFromSystem((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFromSystem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFromSystem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTotalAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pack_amount")) {
      Object obj = map.get("pack_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPackAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_amount")) {
      Object obj = map.get("item_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItemAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("freight_amount")) {
      Object obj = map.get("freight_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFreightAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreightAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreightAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("discount_amount")) {
      Object obj = map.get("discount_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDiscountAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("actual_amount")) {
      Object obj = map.get("actual_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActualAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("change_amount")) {
      Object obj = map.get("change_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChangeAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChangeAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChangeAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pay_model")) {
      Object obj = map.get("pay_model");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayModel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayModel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayModel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_info")) {
      Object obj = map.get("item_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_info")) {
      Object obj = map.get("discount_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("after_sale_status")) {
      Object obj = map.get("after_sale_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAfterSaleStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAfterSaleStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAfterSaleStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receive_status")) {
      Object obj = map.get("receive_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiveStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("performance_status")) {
      Object obj = map.get("performance_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPerformanceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPerformanceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPerformanceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("biz_sub_type")) {
      Object obj = map.get("biz_sub_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBizSubType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBizSubType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBizSubType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("refund_flag")) {
      Object obj = map.get("refund_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefundFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("out_id")) {
      Object obj = map.get("out_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOutId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_flag")) {
      Object obj = map.get("sync_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSyncFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSyncFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSyncFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_deleted")) {
      Object obj = map.get("is_deleted");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsDeleted((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsDeleted(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsDeleted(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStoreId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStoreId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStoreId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("biz_type")) {
      Object obj = map.get("biz_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBizType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBizType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBizType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("store_order_no")) {
      Object obj = map.get("store_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSource((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSource(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSource(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("source_no")) {
      Object obj = map.get("source_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("from_system")) {
      Object obj = map.get("from_system");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFromSystem((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFromSystem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setFromSystem(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTotalAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pack_amount")) {
      Object obj = map.get("pack_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPackAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("item_amount")) {
      Object obj = map.get("item_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setItemAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setItemAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setItemAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("freight_amount")) {
      Object obj = map.get("freight_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFreightAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFreightAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setFreightAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("discount_amount")) {
      Object obj = map.get("discount_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDiscountAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("actual_amount")) {
      Object obj = map.get("actual_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActualAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setActualAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("change_amount")) {
      Object obj = map.get("change_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChangeAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChangeAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setChangeAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pay_model")) {
      Object obj = map.get("pay_model");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayModel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayModel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayModel(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("item_info")) {
      Object obj = map.get("item_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discount_info")) {
      Object obj = map.get("discount_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("after_sale_status")) {
      Object obj = map.get("after_sale_status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAfterSaleStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAfterSaleStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAfterSaleStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receive_status")) {
      Object obj = map.get("receive_status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceiveStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceiveStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceiveStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("performance_status")) {
      Object obj = map.get("performance_status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPerformanceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPerformanceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPerformanceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVersion(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("biz_sub_type")) {
      Object obj = map.get("biz_sub_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBizSubType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBizSubType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBizSubType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("refund_flag")) {
      Object obj = map.get("refund_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRefundFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("out_id")) {
      Object obj = map.get("out_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOutId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sync_flag")) {
      Object obj = map.get("sync_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSyncFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSyncFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSyncFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_deleted")) {
      Object obj = map.get("is_deleted");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsDeleted((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsDeleted(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsDeleted(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStoreId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStoreId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStoreId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
