package com.xforceplus.tocorder.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderEleme implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单Id
   */
  @TableField("orderId")
  private String orderId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 顾客送餐地址
   */
  private String address;

  /**
   * 是否口袋订单
   */
  @TableField("bagOrder")
  private Boolean bagOrder;

  /**
   * 是否预订单
   */
  private Boolean book;

  /**
   * 订单收货人姓名
   */
  private String consignee;

  /**
   * 顾客联系电话
   */
  @TableField("consigneePhones")
  private String consigneePhones;

  /**
   * 下单时间
   */
  @TableField("createdAt")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createdAt;

  /**
   * 店铺当日订单流水号
   */
  @TableField("daySn")
  private Long daySn;

  /**
   * 预计送达时间
   */
  @TableField("deliverTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliverTime;

  /**
   * 配送费原价 + 打包费金额
   */
  @TableField("deliveryPackageFee")
  private BigDecimal deliveryPackageFee;

  /**
   * 物流标品id
   */
  @TableField("deliveryProductId")
  private Long deliveryProductId;

  /**
   * 订单备注
   */
  private String description;

  /**
   * 降级标识
   */
  private Boolean downgraded;

  /**
   * 扩展信息
   */
  @TableField("extraJson")
  private String extraJson;

  /**
   * 履约服务费
   */
  @TableField("fulfillServiceFee")
  private BigDecimal fulfillServiceFee;

  /**
   * 订单详细类目的列表
   */
  private String groups;

  /**
   * 店铺实收
   */
  private BigDecimal income;

  /**
   * 即时单的预计时间
   */
  @TableField("instantOrderDeliverTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime instantOrderDeliverTime;

  /**
   * 店铺绑定的外部ID
   */
  @TableField("openId")
  private String openId;

  /**
   * 订单业务类型
   */
  @TableField("orderBusinessType")
  private String orderBusinessType;

  /**
   * 打包费模块
   */
  @TableField("packageFeeInfo")
  private String packageFeeInfo;

  /**
   * 顾客联系电话
   */
  @TableField("phoneList")
  private String phoneList;

  /**
   * 取货码
   */
  @TableField("pickUpNumber")
  private Long pickUpNumber;

  /**
   * 到店自取时间
   */
  @TableField("pickUpTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime pickUpTime;

  /**
   * 是否是拼团订单
   */
  @TableField("ptOrder")
  private Boolean ptOrder;

  /**
   * 饿了么拼团订单拓展信息
   */
  @TableField("ptOrderExtraData")
  private String ptOrderExtraData;

  /**
   * 店铺Id
   */
  @TableField("shopId")
  private Long shopId;

  /**
   * 店铺名称
   */
  @TableField("shopName")
  private String shopName;

  /**
   * 商流服务商品
   */
  @TableField("skuId")
  private Long skuId;

  /**
   * 用户承担部分（特殊合作商户专用）
   */
  @TableField("specUserPart")
  private BigDecimal specUserPart;

  /**
   * 商流标品id
   */
  @TableField("spuId")
  private Long spuId;

  /**
   * 订单状态
   */
  private String status;

  /**
   * 超级会员标识
   */
  @TableField("superVip")
  private String superVip;

  /**
   * 纳税人识别号
   */
  @TableField("taxpayerId")
  private String taxpayerId;

  /**
   * 总优惠金额
   */
  @TableField("totalActivityAmount")
  private BigDecimal totalActivityAmount;

  /**
   * 总合计金额
   */
  @TableField("totalAmount")
  private BigDecimal totalAmount;

  /**
   * 订单总价，用户实际支付的金额
   */
  @TableField("totalPrice")
  private BigDecimal totalPrice;

  /**
   * 订单商品额外信息
   */
  @TableField("userExtraInfo")
  private String userExtraInfo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 其它字段
   */
  private String extraInfo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderId", orderId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("address", address);
      map.put("bagOrder", bagOrder);
      map.put("book", book);
      map.put("consignee", consignee);
      map.put("consigneePhones", consigneePhones);
      map.put("createdAt", BocpGenUtils.toTimestamp(createdAt));
      map.put("daySn", daySn);
      map.put("deliverTime", BocpGenUtils.toTimestamp(deliverTime));
      map.put("deliveryPackageFee", deliveryPackageFee);
      map.put("deliveryProductId", deliveryProductId);
      map.put("description", description);
      map.put("downgraded", downgraded);
      map.put("extraJson", extraJson);
      map.put("fulfillServiceFee", fulfillServiceFee);
      map.put("groups", groups);
      map.put("income", income);
      map.put("instantOrderDeliverTime", BocpGenUtils.toTimestamp(instantOrderDeliverTime));
      map.put("openId", openId);
      map.put("orderBusinessType", orderBusinessType);
      map.put("packageFeeInfo", packageFeeInfo);
      map.put("phoneList", phoneList);
      map.put("pickUpNumber", pickUpNumber);
      map.put("pickUpTime", BocpGenUtils.toTimestamp(pickUpTime));
      map.put("ptOrder", ptOrder);
      map.put("ptOrderExtraData", ptOrderExtraData);
      map.put("shopId", shopId);
      map.put("shopName", shopName);
      map.put("skuId", skuId);
      map.put("specUserPart", specUserPart);
      map.put("spuId", spuId);
      map.put("status", status);
      map.put("superVip", superVip);
      map.put("taxpayerId", taxpayerId);
      map.put("totalActivityAmount", totalActivityAmount);
      map.put("totalAmount", totalAmount);
      map.put("totalPrice", totalPrice);
      map.put("userExtraInfo", userExtraInfo);
      map.put("invoiceType", invoiceType);
      map.put("extra_info", extraInfo);

      return map;
  }

  public static OrderEleme fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderEleme entity = new OrderEleme();
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bagOrder")) {
      Object obj = map.get("bagOrder");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBagOrder((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBagOrder(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("book")) {
      Object obj = map.get("book");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBook((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBook(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("consignee")) {
      Object obj = map.get("consignee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsignee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consigneePhones")) {
      Object obj = map.get("consigneePhones");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsigneePhones((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createdAt")) {
      Object obj = map.get("createdAt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreatedAt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreatedAt((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreatedAt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreatedAt(null);
      }
    }
    if(map.containsKey("daySn")) {
      Object obj = map.get("daySn");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDaySn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDaySn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDaySn(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deliverTime")) {
      Object obj = map.get("deliverTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliverTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeliverTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliverTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliverTime(null);
      }
    }
    if(map.containsKey("deliveryPackageFee")) {
      Object obj = map.get("deliveryPackageFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeliveryPackageFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeliveryPackageFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeliveryPackageFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryPackageFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeliveryPackageFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deliveryProductId")) {
      Object obj = map.get("deliveryProductId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryProductId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryProductId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeliveryProductId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("description")) {
      Object obj = map.get("description");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downgraded")) {
      Object obj = map.get("downgraded");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setDowngraded((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDowngraded(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("extraJson")) {
      Object obj = map.get("extraJson");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtraJson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fulfillServiceFee")) {
      Object obj = map.get("fulfillServiceFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFulfillServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFulfillServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFulfillServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFulfillServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFulfillServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("groups")) {
      Object obj = map.get("groups");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroups((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("income")) {
      Object obj = map.get("income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("instantOrderDeliverTime")) {
      Object obj = map.get("instantOrderDeliverTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInstantOrderDeliverTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInstantOrderDeliverTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInstantOrderDeliverTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInstantOrderDeliverTime(null);
      }
    }
    if(map.containsKey("openId")) {
      Object obj = map.get("openId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpenId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderBusinessType")) {
      Object obj = map.get("orderBusinessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageFeeInfo")) {
      Object obj = map.get("packageFeeInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageFeeInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phoneList")) {
      Object obj = map.get("phoneList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPhoneList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pickUpNumber")) {
      Object obj = map.get("pickUpNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPickUpNumber((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPickUpNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPickUpNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pickUpTime")) {
      Object obj = map.get("pickUpTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPickUpTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPickUpTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPickUpTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPickUpTime(null);
      }
    }
    if(map.containsKey("ptOrder")) {
      Object obj = map.get("ptOrder");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPtOrder((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtOrder(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("ptOrderExtraData")) {
      Object obj = map.get("ptOrderExtraData");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPtOrderExtraData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shopId")) {
      Object obj = map.get("shopId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShopId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShopId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShopId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("shopName")) {
      Object obj = map.get("shopName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("skuId")) {
      Object obj = map.get("skuId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSkuId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkuId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("specUserPart")) {
      Object obj = map.get("specUserPart");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSpecUserPart((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSpecUserPart(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSpecUserPart(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSpecUserPart(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSpecUserPart(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("spuId")) {
      Object obj = map.get("spuId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSpuId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSpuId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSpuId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("superVip")) {
      Object obj = map.get("superVip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSuperVip((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxpayerId")) {
      Object obj = map.get("taxpayerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxpayerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalActivityAmount")) {
      Object obj = map.get("totalActivityAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalActivityAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalActivityAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalActivityAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalActivityAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalActivityAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalPrice")) {
      Object obj = map.get("totalPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("userExtraInfo")) {
      Object obj = map.get("userExtraInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserExtraInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extra_info")) {
      Object obj = map.get("extra_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtraInfo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bagOrder")) {
      Object obj = map.get("bagOrder");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBagOrder((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBagOrder(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("book")) {
      Object obj = map.get("book");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBook((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBook(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("consignee")) {
      Object obj = map.get("consignee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsignee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consigneePhones")) {
      Object obj = map.get("consigneePhones");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsigneePhones((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createdAt")) {
      Object obj = map.get("createdAt");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreatedAt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreatedAt((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreatedAt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreatedAt(null);
      }
    }
    if(map.containsKey("daySn")) {
      Object obj = map.get("daySn");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDaySn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDaySn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDaySn(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("deliverTime")) {
      Object obj = map.get("deliverTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeliverTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeliverTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliverTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeliverTime(null);
      }
    }
    if(map.containsKey("deliveryPackageFee")) {
      Object obj = map.get("deliveryPackageFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDeliveryPackageFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDeliveryPackageFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDeliveryPackageFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryPackageFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDeliveryPackageFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("deliveryProductId")) {
      Object obj = map.get("deliveryProductId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeliveryProductId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryProductId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDeliveryProductId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("description")) {
      Object obj = map.get("description");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("downgraded")) {
      Object obj = map.get("downgraded");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setDowngraded((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDowngraded(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("extraJson")) {
      Object obj = map.get("extraJson");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtraJson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fulfillServiceFee")) {
      Object obj = map.get("fulfillServiceFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFulfillServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFulfillServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFulfillServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFulfillServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFulfillServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("groups")) {
      Object obj = map.get("groups");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroups((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("income")) {
      Object obj = map.get("income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("instantOrderDeliverTime")) {
      Object obj = map.get("instantOrderDeliverTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInstantOrderDeliverTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInstantOrderDeliverTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInstantOrderDeliverTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInstantOrderDeliverTime(null);
      }
    }
    if(map.containsKey("openId")) {
      Object obj = map.get("openId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpenId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderBusinessType")) {
      Object obj = map.get("orderBusinessType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageFeeInfo")) {
      Object obj = map.get("packageFeeInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageFeeInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("phoneList")) {
      Object obj = map.get("phoneList");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPhoneList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pickUpNumber")) {
      Object obj = map.get("pickUpNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPickUpNumber((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPickUpNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPickUpNumber(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pickUpTime")) {
      Object obj = map.get("pickUpTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPickUpTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPickUpTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPickUpTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPickUpTime(null);
      }
    }
    if(map.containsKey("ptOrder")) {
      Object obj = map.get("ptOrder");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPtOrder((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPtOrder(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("ptOrderExtraData")) {
      Object obj = map.get("ptOrderExtraData");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPtOrderExtraData((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shopId")) {
      Object obj = map.get("shopId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setShopId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShopId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setShopId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("shopName")) {
      Object obj = map.get("shopName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("skuId")) {
      Object obj = map.get("skuId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSkuId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSkuId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSkuId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("specUserPart")) {
      Object obj = map.get("specUserPart");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSpecUserPart((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSpecUserPart(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSpecUserPart(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSpecUserPart(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSpecUserPart(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("spuId")) {
      Object obj = map.get("spuId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSpuId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSpuId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSpuId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("superVip")) {
      Object obj = map.get("superVip");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSuperVip((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxpayerId")) {
      Object obj = map.get("taxpayerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxpayerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("totalActivityAmount")) {
      Object obj = map.get("totalActivityAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalActivityAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalActivityAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalActivityAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalActivityAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalActivityAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalPrice")) {
      Object obj = map.get("totalPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("userExtraInfo")) {
      Object obj = map.get("userExtraInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserExtraInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extra_info")) {
      Object obj = map.get("extra_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtraInfo((String)obj);
        }
      } else {
      }
    }
  }
}
