package com.xforceplus.tocorder.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 霸王茶姬订单商品
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderItemBwcj implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  private String orderNo;

  /**
   * 商品id
   */
  private String itemId;

  /**
   * 商品名称
   */
  private String itemName;

  /**
   * 商品规格
   */
  private String itemSpec;

  /**
   * 商品单位
   */
  private String itemUnit;

  /**
   * 商品标识
   */
  private String itemSign;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 数量
   */
  private BigDecimal num;

  /**
   * 商品价格
   */
  private Long itemPrice;

  /**
   * 优惠金额
   */
  private Long discountAmount;

  /**
   * 活动id
   */
  private Long activityId;

  /**
   * 删除标识
   */
  private Long isDeleted;

  /**
   * 来源商品id
   */
  private Long sourceId;

  /**
   * 商品id
   */
  private Long goodsId;

  /**
   * 限时折扣
   */
  private Long isTimeDiscount;

  /**
   * user_id
   */
  private Long userId;

  /**
   * 状态
   */
  private Long status;

  /**
   * 是否赠品
   */
  private Long isGift;

  /**
   * 商家id
   */
  private Long sellerId;

  /**
   * item_type
   */
  private Long itemType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("order_no", orderNo);
      map.put("item_id", itemId);
      map.put("item_name", itemName);
      map.put("item_spec", itemSpec);
      map.put("item_unit", itemUnit);
      map.put("item_sign", itemSign);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("num", num);
      map.put("item_price", itemPrice);
      map.put("discount_amount", discountAmount);
      map.put("activity_id", activityId);
      map.put("is_deleted", isDeleted);
      map.put("source_id", sourceId);
      map.put("goods_id", goodsId);
      map.put("is_time_discount", isTimeDiscount);
      map.put("user_id", userId);
      map.put("status", status);
      map.put("is_gift", isGift);
      map.put("seller_id", sellerId);
      map.put("item_type", itemType);

      return map;
  }

  public static OrderItemBwcj fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderItemBwcj entity = new OrderItemBwcj();
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_unit")) {
      Object obj = map.get("item_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_sign")) {
      Object obj = map.get("item_sign");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSign((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("num")) {
      Object obj = map.get("num");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNum((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_price")) {
      Object obj = map.get("item_price");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItemPrice((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemPrice(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemPrice(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("discount_amount")) {
      Object obj = map.get("discount_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDiscountAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("activity_id")) {
      Object obj = map.get("activity_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActivityId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActivityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActivityId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_deleted")) {
      Object obj = map.get("is_deleted");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsDeleted((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsDeleted(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsDeleted(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("source_id")) {
      Object obj = map.get("source_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSourceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSourceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSourceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGoodsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_time_discount")) {
      Object obj = map.get("is_time_discount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsTimeDiscount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsTimeDiscount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsTimeDiscount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_gift")) {
      Object obj = map.get("is_gift");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsGift((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsGift(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsGift(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_type")) {
      Object obj = map.get("item_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItemType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_unit")) {
      Object obj = map.get("item_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_sign")) {
      Object obj = map.get("item_sign");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSign((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("num")) {
      Object obj = map.get("num");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNum((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("item_price")) {
      Object obj = map.get("item_price");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setItemPrice((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setItemPrice(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setItemPrice(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("discount_amount")) {
      Object obj = map.get("discount_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDiscountAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("activity_id")) {
      Object obj = map.get("activity_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActivityId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActivityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setActivityId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_deleted")) {
      Object obj = map.get("is_deleted");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsDeleted((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsDeleted(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsDeleted(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("source_id")) {
      Object obj = map.get("source_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSourceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSourceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSourceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGoodsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_time_discount")) {
      Object obj = map.get("is_time_discount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsTimeDiscount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsTimeDiscount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsTimeDiscount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_gift")) {
      Object obj = map.get("is_gift");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsGift((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsGift(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsGift(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("item_type")) {
      Object obj = map.get("item_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setItemType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setItemType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setItemType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
