package com.xforceplus.tocorder.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderJingDong implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("orderId")
  private String orderId;

  /**
   * 订单来源类型
   */
  @TableField("srcInnerType")
  private Long srcInnerType;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private Long orderType;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private Long orderStatus;

  /**
   * 订单状态最新更改时间
   */
  @TableField("orderStatusTime")
  private String orderStatusTime;

  /**
   * 订单商家备注
   */
  @TableField("orderVenderRemark")
  private String orderVenderRemark;

  /**
   * 下单时间
   */
  @TableField("orderStartTime")
  private String orderStartTime;

  /**
   * 订单成交时间
   */
  @TableField("orderPurchaseTime")
  private String orderPurchaseTime;

  /**
   * 订单取消时间
   */
  @TableField("orderCancelTime")
  private String orderCancelTime;

  /**
   * 订单取消备注
   */
  @TableField("orderCancelRemark")
  private String orderCancelRemark;

  /**
   * 商家编码
   */
  @TableField("orgCode")
  private String orgCode;

  /**
   * 到家配送门店编码
   */
  @TableField("deliveryStationNo")
  private String deliveryStationNo;

  /**
   * 商家门店编码
   */
  @TableField("deliveryStationNoIsv")
  private String deliveryStationNoIsv;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 配送门店名称
   */
  @TableField("deliveryStationName")
  private String deliveryStationName;

  /**
   * 承运商编号
   */
  @TableField("deliveryCarrierNo")
  private String deliveryCarrierNo;

  /**
   * 承运商名称
   */
  @TableField("deliveryCarrierName")
  private String deliveryCarrierName;

  /**
   * 承运单号
   */
  @TableField("deliveryBillNo")
  private String deliveryBillNo;

  /**
   * 订单支付类型
   */
  @TableField("orderPayType")
  private Long orderPayType;

  /**
   * 订单支付渠道
   */
  @TableField("payChannel")
  private Long payChannel;

  /**
   * 订单商品销售价总金额
   */
  @TableField("orderTotalMoney")
  private Long orderTotalMoney;

  /**
   * 订单级别优惠商品金额
   */
  @TableField("orderDiscountMoney")
  private Long orderDiscountMoney;

  /**
   * 用户支付的实际订单运费
   */
  @TableField("orderFreightMoney")
  private Long orderFreightMoney;

  /**
   * 订单基础运费
   */
  @TableField("orderBaseFreightMoney")
  private Long orderBaseFreightMoney;

  /**
   * 达达同城送运费
   */
  @TableField("localDeliveryMoney")
  private Long localDeliveryMoney;

  /**
   * 商家支付远距离运费
   */
  @TableField("merchantPaymentDistanceFreightMoney")
  private Long merchantPaymentDistanceFreightMoney;

  /**
   * 订单应收运费
   */
  @TableField("orderReceivableFreight")
  private Long orderReceivableFreight;

  /**
   * 距离阶梯运费
   */
  @TableField("orderDistanceStepFreight")
  private Long orderDistanceStepFreight;

  /**
   * 用户积分抵扣金额
   */
  @TableField("platformPointsDeductionMoney")
  private Long platformPointsDeductionMoney;

  /**
   * 用户应付金额
   */
  @TableField("orderBuyerPayableMoney")
  private Long orderBuyerPayableMoney;

  /**
   * 包装金额
   */
  @TableField("packagingMoney")
  private Long packagingMoney;

  /**
   * 商家给配送员加的小费
   */
  private Long tips;

  /**
   * 存在订单调整
   */
  @TableField("adjustIsExists")
  private Boolean adjustIsExists;

  /**
   * 调整单编号
   */
  @TableField("adjustId")
  private Long adjustId;

  /**
   * 是否拼团订单
   */
  @TableField("isGroupon")
  private Boolean isGroupon;

  /**
   * 业务标识
   */
  @TableField("businessTag")
  private String businessTag;

  /**
   * 设备id
   */
  @TableField("equipmentId")
  private String equipmentId;

  /**
   * 当天门店订单序号
   */
  @TableField("orderNum")
  private Long orderNum;

  /**
   * 用户小费
   */
  @TableField("userTip")
  private Long userTip;

  /**
   * 订单业务类型
   */
  @TableField("businessType")
  private Long businessType;

  /**
   * 商家会员VIP卡号
   */
  @TableField("venderVipCardId")
  private String venderVipCardId;

  /**
   * 订单开发票标识
   */
  @TableField("orderInvoiceOpenMark")
  private Long orderInvoiceOpenMark;

  /**
   * 订单来源系统
   */
  @TableField("srcOrderType")
  private String srcOrderType;

  /**
   * 订单来源系统id
   */
  @TableField("srcOrderId")
  private String srcOrderId;

  /**
   * 包含需要查询订单的商品List列表
   */
  private String product;

  /**
   * 包含需要查询订单的优惠List列表
   */
  private String discount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderId", orderId);
      map.put("srcInnerType", srcInnerType);
      map.put("orderType", orderType);
      map.put("orderStatus", orderStatus);
      map.put("orderStatusTime", orderStatusTime);
      map.put("orderVenderRemark", orderVenderRemark);
      map.put("orderStartTime", orderStartTime);
      map.put("orderPurchaseTime", orderPurchaseTime);
      map.put("orderCancelTime", orderCancelTime);
      map.put("orderCancelRemark", orderCancelRemark);
      map.put("orgCode", orgCode);
      map.put("deliveryStationNo", deliveryStationNo);
      map.put("deliveryStationNoIsv", deliveryStationNoIsv);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deliveryStationName", deliveryStationName);
      map.put("deliveryCarrierNo", deliveryCarrierNo);
      map.put("deliveryCarrierName", deliveryCarrierName);
      map.put("deliveryBillNo", deliveryBillNo);
      map.put("orderPayType", orderPayType);
      map.put("payChannel", payChannel);
      map.put("orderTotalMoney", orderTotalMoney);
      map.put("orderDiscountMoney", orderDiscountMoney);
      map.put("orderFreightMoney", orderFreightMoney);
      map.put("orderBaseFreightMoney", orderBaseFreightMoney);
      map.put("localDeliveryMoney", localDeliveryMoney);
      map.put("merchantPaymentDistanceFreightMoney", merchantPaymentDistanceFreightMoney);
      map.put("orderReceivableFreight", orderReceivableFreight);
      map.put("orderDistanceStepFreight", orderDistanceStepFreight);
      map.put("platformPointsDeductionMoney", platformPointsDeductionMoney);
      map.put("orderBuyerPayableMoney", orderBuyerPayableMoney);
      map.put("packagingMoney", packagingMoney);
      map.put("tips", tips);
      map.put("adjustIsExists", adjustIsExists);
      map.put("adjustId", adjustId);
      map.put("isGroupon", isGroupon);
      map.put("businessTag", businessTag);
      map.put("equipmentId", equipmentId);
      map.put("orderNum", orderNum);
      map.put("userTip", userTip);
      map.put("businessType", businessType);
      map.put("venderVipCardId", venderVipCardId);
      map.put("orderInvoiceOpenMark", orderInvoiceOpenMark);
      map.put("srcOrderType", srcOrderType);
      map.put("srcOrderId", srcOrderId);
      map.put("product", product);
      map.put("discount", discount);

      return map;
  }

  public static OrderJingDong fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderJingDong entity = new OrderJingDong();
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("srcInnerType")) {
      Object obj = map.get("srcInnerType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSrcInnerType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSrcInnerType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSrcInnerType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatusTime")) {
      Object obj = map.get("orderStatusTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatusTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderVenderRemark")) {
      Object obj = map.get("orderVenderRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderVenderRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStartTime")) {
      Object obj = map.get("orderStartTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderPurchaseTime")) {
      Object obj = map.get("orderPurchaseTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderPurchaseTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderCancelTime")) {
      Object obj = map.get("orderCancelTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderCancelTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderCancelRemark")) {
      Object obj = map.get("orderCancelRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderCancelRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgCode")) {
      Object obj = map.get("orgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryStationNo")) {
      Object obj = map.get("deliveryStationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryStationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryStationNoIsv")) {
      Object obj = map.get("deliveryStationNoIsv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryStationNoIsv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryStationName")) {
      Object obj = map.get("deliveryStationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryStationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryCarrierNo")) {
      Object obj = map.get("deliveryCarrierNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryCarrierNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryCarrierName")) {
      Object obj = map.get("deliveryCarrierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryCarrierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryBillNo")) {
      Object obj = map.get("deliveryBillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderPayType")) {
      Object obj = map.get("orderPayType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderPayType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderPayType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderPayType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("payChannel")) {
      Object obj = map.get("payChannel");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayChannel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayChannel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayChannel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderTotalMoney")) {
      Object obj = map.get("orderTotalMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTotalMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTotalMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderDiscountMoney")) {
      Object obj = map.get("orderDiscountMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderDiscountMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderDiscountMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderDiscountMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderFreightMoney")) {
      Object obj = map.get("orderFreightMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderFreightMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderFreightMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderFreightMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderBaseFreightMoney")) {
      Object obj = map.get("orderBaseFreightMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderBaseFreightMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderBaseFreightMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderBaseFreightMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("localDeliveryMoney")) {
      Object obj = map.get("localDeliveryMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLocalDeliveryMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLocalDeliveryMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLocalDeliveryMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("merchantPaymentDistanceFreightMoney")) {
      Object obj = map.get("merchantPaymentDistanceFreightMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMerchantPaymentDistanceFreightMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMerchantPaymentDistanceFreightMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMerchantPaymentDistanceFreightMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderReceivableFreight")) {
      Object obj = map.get("orderReceivableFreight");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderReceivableFreight((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderReceivableFreight(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderReceivableFreight(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderDistanceStepFreight")) {
      Object obj = map.get("orderDistanceStepFreight");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderDistanceStepFreight((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderDistanceStepFreight(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderDistanceStepFreight(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("platformPointsDeductionMoney")) {
      Object obj = map.get("platformPointsDeductionMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPlatformPointsDeductionMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformPointsDeductionMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformPointsDeductionMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderBuyerPayableMoney")) {
      Object obj = map.get("orderBuyerPayableMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderBuyerPayableMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderBuyerPayableMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderBuyerPayableMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("packagingMoney")) {
      Object obj = map.get("packagingMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPackagingMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackagingMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackagingMoney(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tips")) {
      Object obj = map.get("tips");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTips((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTips(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTips(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("adjustIsExists")) {
      Object obj = map.get("adjustIsExists");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setAdjustIsExists((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAdjustIsExists(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("adjustId")) {
      Object obj = map.get("adjustId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAdjustId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAdjustId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAdjustId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("isGroupon")) {
      Object obj = map.get("isGroupon");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsGroupon((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsGroupon(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("businessTag")) {
      Object obj = map.get("businessTag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("equipmentId")) {
      Object obj = map.get("equipmentId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEquipmentId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNum")) {
      Object obj = map.get("orderNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("userTip")) {
      Object obj = map.get("userTip");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserTip((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserTip(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUserTip(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("venderVipCardId")) {
      Object obj = map.get("venderVipCardId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVenderVipCardId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderInvoiceOpenMark")) {
      Object obj = map.get("orderInvoiceOpenMark");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderInvoiceOpenMark((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderInvoiceOpenMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderInvoiceOpenMark(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("srcOrderType")) {
      Object obj = map.get("srcOrderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("srcOrderId")) {
      Object obj = map.get("srcOrderId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProduct((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount")) {
      Object obj = map.get("discount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscount((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("srcInnerType")) {
      Object obj = map.get("srcInnerType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSrcInnerType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSrcInnerType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSrcInnerType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderStatusTime")) {
      Object obj = map.get("orderStatusTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatusTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderVenderRemark")) {
      Object obj = map.get("orderVenderRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderVenderRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderStartTime")) {
      Object obj = map.get("orderStartTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStartTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderPurchaseTime")) {
      Object obj = map.get("orderPurchaseTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderPurchaseTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderCancelTime")) {
      Object obj = map.get("orderCancelTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderCancelTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderCancelRemark")) {
      Object obj = map.get("orderCancelRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderCancelRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orgCode")) {
      Object obj = map.get("orgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryStationNo")) {
      Object obj = map.get("deliveryStationNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryStationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryStationNoIsv")) {
      Object obj = map.get("deliveryStationNoIsv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryStationNoIsv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryStationName")) {
      Object obj = map.get("deliveryStationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryStationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryCarrierNo")) {
      Object obj = map.get("deliveryCarrierNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryCarrierNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryCarrierName")) {
      Object obj = map.get("deliveryCarrierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryCarrierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryBillNo")) {
      Object obj = map.get("deliveryBillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderPayType")) {
      Object obj = map.get("orderPayType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderPayType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderPayType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderPayType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("payChannel")) {
      Object obj = map.get("payChannel");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayChannel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayChannel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayChannel(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderTotalMoney")) {
      Object obj = map.get("orderTotalMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderTotalMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTotalMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderTotalMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderDiscountMoney")) {
      Object obj = map.get("orderDiscountMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderDiscountMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderDiscountMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderDiscountMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderFreightMoney")) {
      Object obj = map.get("orderFreightMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderFreightMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderFreightMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderFreightMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderBaseFreightMoney")) {
      Object obj = map.get("orderBaseFreightMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderBaseFreightMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderBaseFreightMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderBaseFreightMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("localDeliveryMoney")) {
      Object obj = map.get("localDeliveryMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLocalDeliveryMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLocalDeliveryMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLocalDeliveryMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("merchantPaymentDistanceFreightMoney")) {
      Object obj = map.get("merchantPaymentDistanceFreightMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMerchantPaymentDistanceFreightMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMerchantPaymentDistanceFreightMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMerchantPaymentDistanceFreightMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderReceivableFreight")) {
      Object obj = map.get("orderReceivableFreight");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderReceivableFreight((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderReceivableFreight(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderReceivableFreight(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderDistanceStepFreight")) {
      Object obj = map.get("orderDistanceStepFreight");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderDistanceStepFreight((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderDistanceStepFreight(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderDistanceStepFreight(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("platformPointsDeductionMoney")) {
      Object obj = map.get("platformPointsDeductionMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPlatformPointsDeductionMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatformPointsDeductionMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPlatformPointsDeductionMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderBuyerPayableMoney")) {
      Object obj = map.get("orderBuyerPayableMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderBuyerPayableMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderBuyerPayableMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderBuyerPayableMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("packagingMoney")) {
      Object obj = map.get("packagingMoney");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPackagingMoney((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackagingMoney(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackagingMoney(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tips")) {
      Object obj = map.get("tips");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTips((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTips(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTips(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("adjustIsExists")) {
      Object obj = map.get("adjustIsExists");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setAdjustIsExists((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAdjustIsExists(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("adjustId")) {
      Object obj = map.get("adjustId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAdjustId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAdjustId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAdjustId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("isGroupon")) {
      Object obj = map.get("isGroupon");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsGroupon((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsGroupon(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("businessTag")) {
      Object obj = map.get("businessTag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("equipmentId")) {
      Object obj = map.get("equipmentId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEquipmentId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderNum")) {
      Object obj = map.get("orderNum");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("userTip")) {
      Object obj = map.get("userTip");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUserTip((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUserTip(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUserTip(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("venderVipCardId")) {
      Object obj = map.get("venderVipCardId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVenderVipCardId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderInvoiceOpenMark")) {
      Object obj = map.get("orderInvoiceOpenMark");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderInvoiceOpenMark((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderInvoiceOpenMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderInvoiceOpenMark(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("srcOrderType")) {
      Object obj = map.get("srcOrderType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("srcOrderId")) {
      Object obj = map.get("srcOrderId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProduct((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discount")) {
      Object obj = map.get("discount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscount((String)obj);
        }
      } else {
      }
    }
  }
}
