package com.xforceplus.tocorder.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 美团订单
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderMeiTuan implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务方标识
   */
  private String appId;

  /**
   * 推送时间戳
   */
  private String timestamp;

  /**
   * 门店ID
   */
  private String appPoiCode;

  /**
   * 订单ID
   */
  private String orderId;

  /**
   * 订单展示ID
   */
  private String wmOrderIdView;

  /**
   * 美团商家名称
   */
  private String wmPoiName;

  /**
   * 美团商家地址
   */
  private String wmPoiAddress;

  /**
   * 美团商家电话
   */
  private String wmPoiPhone;

  /**
   * 收件人电话
   */
  private String recipientPhone;

  /**
   * 用户真实手机号后4位
   */
  private String recipientPhoneEnd;

  /**
   * 收件人姓名
   */
  private String recipientName;

  /**
   * 忌口或备注
   */
  private String caution;

  /**
   * 订单状态
   */
  private String status;

  /**
   * 创建时间
   */
  private String ctime;

  /**
   * 更新时间
   */
  private String utime;

  /**
   * 用户预计送达时间
   */
  private String deliveryTime;

  /**
   * 送达时间
   */
  private String estimateArrivalTime;

  /**
   * 是否是第三方配送平台配送
   */
  private String isThirdShipping;

  /**
   * 取餐类型
   */
  private String pickType;

  /**
   * 门店当天的推单流水号
   */
  private String daySeq;

  /**
   * 用餐人数
   */
  private String dinnersNumber;

  /**
   * 订单配送方式
   */
  private String logisticsCode;

  /**
   * 用户下单时间
   */
  private String orderSendTime;

  /**
   * 商户确认时间
   */
  private String orderConfirmTime;

  /**
   * 订单是否修改
   */
  private String opType;

  /**
   * 订单详情
   */
  @TableField("wmAppOrderFoods")
  private String wmAppOrderFoods;

  /**
   * 出餐时效
   */
  @TableField("poiMealAssessmentTime")
  private String poiMealAssessmentTime;

  /**
   * 打包费模式
   */
  private String packageBagMode;

  /**
   * 打包费金额
   */
  private BigDecimal packageBagFee;

  /**
   * 口袋打包费明细
   */
  private String packageBagCartDetail;

  /**
   * 是否为美团企业版订单
   */
  @TableField("sqtOrder")
  private String sqtOrder;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 活动
   */
  private String activity;

  /**
   * 签名
   */
  private String sig;

  /**
   * 其它字段
   */
  private String extraInfo;

  /**
   * 原始价格
   */
  @TableField("originalPrice")
  private BigDecimal originalPrice;

  /**
   * 是否需要开票给美团企业版
   */
  @TableField("sqtNeedInvoice")
  private String sqtNeedInvoice;

  /**
   * 订单金额
   */
  private BigDecimal total;

  /**
   * 支付类型
   */
  @TableField("payType")
  private String payType;

  /**
   * 门店配送费
   */
  @TableField("shippingFee")
  private BigDecimal shippingFee;

  /**
   * 订单完成时间
   */
  @TableField("orderCompletedTime")
  private String orderCompletedTime;

  /**
   * 商家对账信息
   */
  @TableField("poiReceiveDetail")
  private String poiReceiveDetail;

  /**
   * 透传给第三方的偏移后user_id
   */
  @TableField("userIdView")
  private String userIdView;

  /**
   * 配送单下单时间
   */
  @TableField("logisticsSendTime")
  private String logisticsSendTime;

  /**
   * 配送单确认时间
   */
  @TableField("logisticsConfirmTime")
  private String logisticsConfirmTime;

  /**
   * 配送单取消时间
   */
  @TableField("logisticsCancelTime")
  private String logisticsCancelTime;

  /**
   * 骑手取单时间
   */
  @TableField("logisticsFetchTime")
  private String logisticsFetchTime;

  /**
   * 配送完成时间
   */
  @TableField("logisticsCompletedTime")
  private String logisticsCompletedTime;

  /**
   * 订单取消时间
   */
  @TableField("orderReceiveTime")
  private String orderReceiveTime;

  /**
   * 订单完成时间
   */
  @TableField("orderCancelTime")
  private String orderCancelTime;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("app_id", appId);
      map.put("timestamp", timestamp);
      map.put("app_poi_code", appPoiCode);
      map.put("order_id", orderId);
      map.put("wm_order_id_view", wmOrderIdView);
      map.put("wm_poi_name", wmPoiName);
      map.put("wm_poi_address", wmPoiAddress);
      map.put("wm_poi_phone", wmPoiPhone);
      map.put("recipient_phone", recipientPhone);
      map.put("recipient_phone_end", recipientPhoneEnd);
      map.put("recipient_name", recipientName);
      map.put("caution", caution);
      map.put("status", status);
      map.put("ctime", ctime);
      map.put("utime", utime);
      map.put("delivery_time", deliveryTime);
      map.put("estimate_arrival_time", estimateArrivalTime);
      map.put("is_third_shipping", isThirdShipping);
      map.put("pick_type", pickType);
      map.put("day_seq", daySeq);
      map.put("dinners_number", dinnersNumber);
      map.put("logistics_code", logisticsCode);
      map.put("order_send_time", orderSendTime);
      map.put("order_confirm_time", orderConfirmTime);
      map.put("op_type", opType);
      map.put("wmAppOrderFoods", wmAppOrderFoods);
      map.put("poiMealAssessmentTime", poiMealAssessmentTime);
      map.put("package_bag_mode", packageBagMode);
      map.put("package_bag_fee", packageBagFee);
      map.put("package_bag_cart_detail", packageBagCartDetail);
      map.put("sqtOrder", sqtOrder);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("activity", activity);
      map.put("sig", sig);
      map.put("extra_info", extraInfo);
      map.put("originalPrice", originalPrice);
      map.put("sqtNeedInvoice", sqtNeedInvoice);
      map.put("total", total);
      map.put("payType", payType);
      map.put("shippingFee", shippingFee);
      map.put("orderCompletedTime", orderCompletedTime);
      map.put("poiReceiveDetail", poiReceiveDetail);
      map.put("userIdView", userIdView);
      map.put("logisticsSendTime", logisticsSendTime);
      map.put("logisticsConfirmTime", logisticsConfirmTime);
      map.put("logisticsCancelTime", logisticsCancelTime);
      map.put("logisticsFetchTime", logisticsFetchTime);
      map.put("logisticsCompletedTime", logisticsCompletedTime);
      map.put("orderReceiveTime", orderReceiveTime);
      map.put("orderCancelTime", orderCancelTime);

      return map;
  }

  public static OrderMeiTuan fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderMeiTuan entity = new OrderMeiTuan();
    if(map.containsKey("app_id")) {
      Object obj = map.get("app_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("timestamp")) {
      Object obj = map.get("timestamp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTimestamp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("app_poi_code")) {
      Object obj = map.get("app_poi_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppPoiCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wm_order_id_view")) {
      Object obj = map.get("wm_order_id_view");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWmOrderIdView((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wm_poi_name")) {
      Object obj = map.get("wm_poi_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWmPoiName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wm_poi_address")) {
      Object obj = map.get("wm_poi_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWmPoiAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wm_poi_phone")) {
      Object obj = map.get("wm_poi_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWmPoiPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recipient_phone")) {
      Object obj = map.get("recipient_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecipientPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recipient_phone_end")) {
      Object obj = map.get("recipient_phone_end");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecipientPhoneEnd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recipient_name")) {
      Object obj = map.get("recipient_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecipientName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("caution")) {
      Object obj = map.get("caution");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCaution((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ctime")) {
      Object obj = map.get("ctime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCtime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("utime")) {
      Object obj = map.get("utime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUtime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_time")) {
      Object obj = map.get("delivery_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("estimate_arrival_time")) {
      Object obj = map.get("estimate_arrival_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEstimateArrivalTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_third_shipping")) {
      Object obj = map.get("is_third_shipping");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsThirdShipping((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pick_type")) {
      Object obj = map.get("pick_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPickType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("day_seq")) {
      Object obj = map.get("day_seq");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDaySeq((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dinners_number")) {
      Object obj = map.get("dinners_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDinnersNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_code")) {
      Object obj = map.get("logistics_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_send_time")) {
      Object obj = map.get("order_send_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderSendTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_confirm_time")) {
      Object obj = map.get("order_confirm_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderConfirmTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("op_type")) {
      Object obj = map.get("op_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wmAppOrderFoods")) {
      Object obj = map.get("wmAppOrderFoods");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWmAppOrderFoods((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poiMealAssessmentTime")) {
      Object obj = map.get("poiMealAssessmentTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoiMealAssessmentTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_bag_mode")) {
      Object obj = map.get("package_bag_mode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageBagMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_bag_fee")) {
      Object obj = map.get("package_bag_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageBagFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageBagFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageBagFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageBagFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageBagFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_bag_cart_detail")) {
      Object obj = map.get("package_bag_cart_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageBagCartDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqtOrder")) {
      Object obj = map.get("sqtOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqtOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("activity")) {
      Object obj = map.get("activity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActivity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sig")) {
      Object obj = map.get("sig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extra_info")) {
      Object obj = map.get("extra_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtraInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalPrice")) {
      Object obj = map.get("originalPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOriginalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sqtNeedInvoice")) {
      Object obj = map.get("sqtNeedInvoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqtNeedInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippingFee")) {
      Object obj = map.get("shippingFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShippingFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShippingFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShippingFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShippingFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShippingFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderCompletedTime")) {
      Object obj = map.get("orderCompletedTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderCompletedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poiReceiveDetail")) {
      Object obj = map.get("poiReceiveDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoiReceiveDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userIdView")) {
      Object obj = map.get("userIdView");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserIdView((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsSendTime")) {
      Object obj = map.get("logisticsSendTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsSendTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsConfirmTime")) {
      Object obj = map.get("logisticsConfirmTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsConfirmTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsCancelTime")) {
      Object obj = map.get("logisticsCancelTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsCancelTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsFetchTime")) {
      Object obj = map.get("logisticsFetchTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsFetchTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsCompletedTime")) {
      Object obj = map.get("logisticsCompletedTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsCompletedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderReceiveTime")) {
      Object obj = map.get("orderReceiveTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderReceiveTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderCancelTime")) {
      Object obj = map.get("orderCancelTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderCancelTime((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("app_id")) {
      Object obj = map.get("app_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("timestamp")) {
      Object obj = map.get("timestamp");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTimestamp((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("app_poi_code")) {
      Object obj = map.get("app_poi_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppPoiCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wm_order_id_view")) {
      Object obj = map.get("wm_order_id_view");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWmOrderIdView((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wm_poi_name")) {
      Object obj = map.get("wm_poi_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWmPoiName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wm_poi_address")) {
      Object obj = map.get("wm_poi_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWmPoiAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wm_poi_phone")) {
      Object obj = map.get("wm_poi_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWmPoiPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recipient_phone")) {
      Object obj = map.get("recipient_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecipientPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recipient_phone_end")) {
      Object obj = map.get("recipient_phone_end");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecipientPhoneEnd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recipient_name")) {
      Object obj = map.get("recipient_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecipientName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("caution")) {
      Object obj = map.get("caution");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCaution((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ctime")) {
      Object obj = map.get("ctime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCtime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("utime")) {
      Object obj = map.get("utime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUtime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delivery_time")) {
      Object obj = map.get("delivery_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("estimate_arrival_time")) {
      Object obj = map.get("estimate_arrival_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEstimateArrivalTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_third_shipping")) {
      Object obj = map.get("is_third_shipping");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsThirdShipping((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pick_type")) {
      Object obj = map.get("pick_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPickType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("day_seq")) {
      Object obj = map.get("day_seq");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDaySeq((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dinners_number")) {
      Object obj = map.get("dinners_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDinnersNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_code")) {
      Object obj = map.get("logistics_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_send_time")) {
      Object obj = map.get("order_send_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderSendTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_confirm_time")) {
      Object obj = map.get("order_confirm_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderConfirmTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("op_type")) {
      Object obj = map.get("op_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wmAppOrderFoods")) {
      Object obj = map.get("wmAppOrderFoods");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWmAppOrderFoods((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poiMealAssessmentTime")) {
      Object obj = map.get("poiMealAssessmentTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoiMealAssessmentTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("package_bag_mode")) {
      Object obj = map.get("package_bag_mode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageBagMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("package_bag_fee")) {
      Object obj = map.get("package_bag_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageBagFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageBagFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageBagFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackageBagFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageBagFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("package_bag_cart_detail")) {
      Object obj = map.get("package_bag_cart_detail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageBagCartDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sqtOrder")) {
      Object obj = map.get("sqtOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqtOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("activity")) {
      Object obj = map.get("activity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActivity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sig")) {
      Object obj = map.get("sig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extra_info")) {
      Object obj = map.get("extra_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtraInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalPrice")) {
      Object obj = map.get("originalPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOriginalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOriginalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOriginalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOriginalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOriginalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sqtNeedInvoice")) {
      Object obj = map.get("sqtNeedInvoice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqtNeedInvoice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippingFee")) {
      Object obj = map.get("shippingFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setShippingFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setShippingFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setShippingFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShippingFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setShippingFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("orderCompletedTime")) {
      Object obj = map.get("orderCompletedTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderCompletedTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poiReceiveDetail")) {
      Object obj = map.get("poiReceiveDetail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoiReceiveDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("userIdView")) {
      Object obj = map.get("userIdView");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserIdView((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticsSendTime")) {
      Object obj = map.get("logisticsSendTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsSendTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticsConfirmTime")) {
      Object obj = map.get("logisticsConfirmTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsConfirmTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticsCancelTime")) {
      Object obj = map.get("logisticsCancelTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsCancelTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticsFetchTime")) {
      Object obj = map.get("logisticsFetchTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsFetchTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticsCompletedTime")) {
      Object obj = map.get("logisticsCompletedTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsCompletedTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderReceiveTime")) {
      Object obj = map.get("orderReceiveTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderReceiveTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderCancelTime")) {
      Object obj = map.get("orderCancelTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderCancelTime((String)obj);
        }
      } else {
      }
    }
  }
}
