package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderBwcj;
import com.xforceplus.tocorder.service.IOrderBwcjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 霸王茶姬订单前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class OrderBwcjController {

  @Autowired
  private IOrderBwcjService orderBwcjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderBwcj 霸王茶姬订单
   * @return
   */
  @GetMapping("/orderbwcjs" )
  public XfR getOrderBwcjs(XfPage page, OrderBwcj orderBwcj) {
    return XfR.ok(orderBwcjServiceImpl.page(page, Wrappers.query(orderBwcj)));
  }

  /**
   * 通过id查询霸王茶姬订单
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderbwcjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderBwcjServiceImpl.getById(id));
  }

  /**
   * 新增霸王茶姬订单
   * @param orderBwcj 霸王茶姬订单
   * @return XfR
   */
  @PostMapping("/orderbwcjs")
  public XfR save(@RequestBody OrderBwcj orderBwcj) {
     return XfR.ok(orderBwcjServiceImpl.save(orderBwcj));
  }

  /**
   * 修改-传入修改后的全部数据霸王茶姬订单
   * @param orderBwcj 霸王茶姬订单
   * @return XfR
   */
  @PutMapping("/orderbwcjs/{id}")
  public XfR putUpdate(@RequestBody OrderBwcj orderBwcj,@PathVariable Long id) {
      orderBwcj.setId(id);
      return XfR.ok(orderBwcjServiceImpl.updateById(orderBwcj));
  }

  /**
   * 修改-传入修改的数据霸王茶姬订单
   * @param orderBwcj 霸王茶姬订单
   * @return XfR
   */
  @PatchMapping("/orderbwcjs/{id}")
  public XfR patchUpdate(@RequestBody OrderBwcj orderBwcj,@PathVariable Long id) {
      OrderBwcj uporderBwcj = orderBwcjServiceImpl.getById(id);
      if(uporderBwcj != null){
        uporderBwcj = ObjectCopyUtils.copyProperties(orderBwcj,uporderBwcj,true);
      }
      return XfR.ok(orderBwcjServiceImpl.updateById(uporderBwcj));
  }

  /**
   * 通过id删除霸王茶姬订单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderbwcjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderBwcjServiceImpl.removeById(id));
  }

  @PostMapping("/orderbwcjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_bwcj");
     params.put("request", condition);

     return XfR.ok(orderBwcjServiceImpl.querys(params));
  }

}
