package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderEleme;
import com.xforceplus.tocorder.service.IOrderElemeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class OrderElemeController {

  @Autowired
  private IOrderElemeService orderElemeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderEleme ${table.comment}
   * @return
   */
  @GetMapping("/orderelemes" )
  public XfR getOrderElemes(XfPage page, OrderEleme orderEleme) {
    return XfR.ok(orderElemeServiceImpl.page(page, Wrappers.query(orderEleme)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderelemes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderElemeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderEleme ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderelemes")
  public XfR save(@RequestBody OrderEleme orderEleme) {
     return XfR.ok(orderElemeServiceImpl.save(orderEleme));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderEleme ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderelemes/{id}")
  public XfR putUpdate(@RequestBody OrderEleme orderEleme,@PathVariable Long id) {
      orderEleme.setId(id);
      return XfR.ok(orderElemeServiceImpl.updateById(orderEleme));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderEleme ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderelemes/{id}")
  public XfR patchUpdate(@RequestBody OrderEleme orderEleme,@PathVariable Long id) {
      OrderEleme uporderEleme = orderElemeServiceImpl.getById(id);
      if(uporderEleme != null){
        uporderEleme = ObjectCopyUtils.copyProperties(orderEleme,uporderEleme,true);
      }
      return XfR.ok(orderElemeServiceImpl.updateById(uporderEleme));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderelemes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderElemeServiceImpl.removeById(id));
  }

  @PostMapping("/orderelemes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_eleme");
     params.put("request", condition);

     return XfR.ok(orderElemeServiceImpl.querys(params));
  }

}
