package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderItemBwcj;
import com.xforceplus.tocorder.service.IOrderItemBwcjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 霸王茶姬订单商品前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class OrderItemBwcjController {

  @Autowired
  private IOrderItemBwcjService orderItemBwcjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderItemBwcj 霸王茶姬订单商品
   * @return
   */
  @GetMapping("/orderitembwcjs" )
  public XfR getOrderItemBwcjs(XfPage page, OrderItemBwcj orderItemBwcj) {
    return XfR.ok(orderItemBwcjServiceImpl.page(page, Wrappers.query(orderItemBwcj)));
  }

  /**
   * 通过id查询霸王茶姬订单商品
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitembwcjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderItemBwcjServiceImpl.getById(id));
  }

  /**
   * 新增霸王茶姬订单商品
   * @param orderItemBwcj 霸王茶姬订单商品
   * @return XfR
   */
  @PostMapping("/orderitembwcjs")
  public XfR save(@RequestBody OrderItemBwcj orderItemBwcj) {
     return XfR.ok(orderItemBwcjServiceImpl.save(orderItemBwcj));
  }

  /**
   * 修改-传入修改后的全部数据霸王茶姬订单商品
   * @param orderItemBwcj 霸王茶姬订单商品
   * @return XfR
   */
  @PutMapping("/orderitembwcjs/{id}")
  public XfR putUpdate(@RequestBody OrderItemBwcj orderItemBwcj,@PathVariable Long id) {
      orderItemBwcj.setId(id);
      return XfR.ok(orderItemBwcjServiceImpl.updateById(orderItemBwcj));
  }

  /**
   * 修改-传入修改的数据霸王茶姬订单商品
   * @param orderItemBwcj 霸王茶姬订单商品
   * @return XfR
   */
  @PatchMapping("/orderitembwcjs/{id}")
  public XfR patchUpdate(@RequestBody OrderItemBwcj orderItemBwcj,@PathVariable Long id) {
      OrderItemBwcj uporderItemBwcj = orderItemBwcjServiceImpl.getById(id);
      if(uporderItemBwcj != null){
        uporderItemBwcj = ObjectCopyUtils.copyProperties(orderItemBwcj,uporderItemBwcj,true);
      }
      return XfR.ok(orderItemBwcjServiceImpl.updateById(uporderItemBwcj));
  }

  /**
   * 通过id删除霸王茶姬订单商品
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitembwcjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderItemBwcjServiceImpl.removeById(id));
  }

  @PostMapping("/orderitembwcjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_item_bwcj");
     params.put("request", condition);

     return XfR.ok(orderItemBwcjServiceImpl.querys(params));
  }

}
