package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderJingDong;
import com.xforceplus.tocorder.service.IOrderJingDongService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class OrderJingDongController {

  @Autowired
  private IOrderJingDongService orderJingDongServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderJingDong ${table.comment}
   * @return
   */
  @GetMapping("/orderjingdongs" )
  public XfR getOrderJingDongs(XfPage page, OrderJingDong orderJingDong) {
    return XfR.ok(orderJingDongServiceImpl.page(page, Wrappers.query(orderJingDong)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderjingdongs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderJingDongServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderJingDong ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderjingdongs")
  public XfR save(@RequestBody OrderJingDong orderJingDong) {
     return XfR.ok(orderJingDongServiceImpl.save(orderJingDong));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderJingDong ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderjingdongs/{id}")
  public XfR putUpdate(@RequestBody OrderJingDong orderJingDong,@PathVariable Long id) {
      orderJingDong.setId(id);
      return XfR.ok(orderJingDongServiceImpl.updateById(orderJingDong));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderJingDong ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderjingdongs/{id}")
  public XfR patchUpdate(@RequestBody OrderJingDong orderJingDong,@PathVariable Long id) {
      OrderJingDong uporderJingDong = orderJingDongServiceImpl.getById(id);
      if(uporderJingDong != null){
        uporderJingDong = ObjectCopyUtils.copyProperties(orderJingDong,uporderJingDong,true);
      }
      return XfR.ok(orderJingDongServiceImpl.updateById(uporderJingDong));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderjingdongs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderJingDongServiceImpl.removeById(id));
  }

  @PostMapping("/orderjingdongs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_jing_dong");
     params.put("request", condition);

     return XfR.ok(orderJingDongServiceImpl.querys(params));
  }

}
