package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.OrderMeiTuan;
import com.xforceplus.tocorder.service.IOrderMeiTuanService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 美团订单前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class OrderMeiTuanController {

  @Autowired
  private IOrderMeiTuanService orderMeiTuanServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderMeiTuan 美团订单
   * @return
   */
  @GetMapping("/ordermeituans" )
  public XfR getOrderMeiTuans(XfPage page, OrderMeiTuan orderMeiTuan) {
    return XfR.ok(orderMeiTuanServiceImpl.page(page, Wrappers.query(orderMeiTuan)));
  }

  /**
   * 通过id查询美团订单
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermeituans/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderMeiTuanServiceImpl.getById(id));
  }

  /**
   * 新增美团订单
   * @param orderMeiTuan 美团订单
   * @return XfR
   */
  @PostMapping("/ordermeituans")
  public XfR save(@RequestBody OrderMeiTuan orderMeiTuan) {
     return XfR.ok(orderMeiTuanServiceImpl.save(orderMeiTuan));
  }

  /**
   * 修改-传入修改后的全部数据美团订单
   * @param orderMeiTuan 美团订单
   * @return XfR
   */
  @PutMapping("/ordermeituans/{id}")
  public XfR putUpdate(@RequestBody OrderMeiTuan orderMeiTuan,@PathVariable Long id) {
      orderMeiTuan.setId(id);
      return XfR.ok(orderMeiTuanServiceImpl.updateById(orderMeiTuan));
  }

  /**
   * 修改-传入修改的数据美团订单
   * @param orderMeiTuan 美团订单
   * @return XfR
   */
  @PatchMapping("/ordermeituans/{id}")
  public XfR patchUpdate(@RequestBody OrderMeiTuan orderMeiTuan,@PathVariable Long id) {
      OrderMeiTuan uporderMeiTuan = orderMeiTuanServiceImpl.getById(id);
      if(uporderMeiTuan != null){
        uporderMeiTuan = ObjectCopyUtils.copyProperties(orderMeiTuan,uporderMeiTuan,true);
      }
      return XfR.ok(orderMeiTuanServiceImpl.updateById(uporderMeiTuan));
  }

  /**
   * 通过id删除美团订单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermeituans/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderMeiTuanServiceImpl.removeById(id));
  }

  @PostMapping("/ordermeituans/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_mei_tuan");
     params.put("request", condition);

     return XfR.ok(orderMeiTuanServiceImpl.querys(params));
  }

}
