package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.SystemMessageModule;
import com.xforceplus.tocorder.service.ISystemMessageModuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统消息模块对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class SystemMessageModuleController {

  @Autowired
  private ISystemMessageModuleService systemMessageModuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemMessageModule 系统消息模块对象
   * @return
   */
  @GetMapping("/systemmessagemodules" )
  public XfR getSystemMessageModules(XfPage page, SystemMessageModule systemMessageModule) {
    return XfR.ok(systemMessageModuleServiceImpl.page(page, Wrappers.query(systemMessageModule)));
  }

  /**
   * 通过id查询系统消息模块对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemmessagemodules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemMessageModuleServiceImpl.getById(id));
  }

  /**
   * 新增系统消息模块对象
   * @param systemMessageModule 系统消息模块对象
   * @return XfR
   */
  @PostMapping("/systemmessagemodules")
  public XfR save(@RequestBody SystemMessageModule systemMessageModule) {
     return XfR.ok(systemMessageModuleServiceImpl.save(systemMessageModule));
  }

  /**
   * 修改-传入修改后的全部数据系统消息模块对象
   * @param systemMessageModule 系统消息模块对象
   * @return XfR
   */
  @PutMapping("/systemmessagemodules/{id}")
  public XfR putUpdate(@RequestBody SystemMessageModule systemMessageModule,@PathVariable Long id) {
      systemMessageModule.setId(id);
      return XfR.ok(systemMessageModuleServiceImpl.updateById(systemMessageModule));
  }

  /**
   * 修改-传入修改的数据系统消息模块对象
   * @param systemMessageModule 系统消息模块对象
   * @return XfR
   */
  @PatchMapping("/systemmessagemodules/{id}")
  public XfR patchUpdate(@RequestBody SystemMessageModule systemMessageModule,@PathVariable Long id) {
      SystemMessageModule upsystemMessageModule = systemMessageModuleServiceImpl.getById(id);
      if(upsystemMessageModule != null){
        upsystemMessageModule = ObjectCopyUtils.copyProperties(systemMessageModule,upsystemMessageModule,true);
      }
      return XfR.ok(systemMessageModuleServiceImpl.updateById(upsystemMessageModule));
  }

  /**
   * 通过id删除系统消息模块对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemmessagemodules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemMessageModuleServiceImpl.removeById(id));
  }

  @PostMapping("/systemmessagemodules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_message_module");
     params.put("request", condition);

     return XfR.ok(systemMessageModuleServiceImpl.querys(params));
  }

}
