package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.SystemRelOrgUser;
import com.xforceplus.tocorder.service.ISystemRelOrgUserService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 人员组织关系系统对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class SystemRelOrgUserController {

  @Autowired
  private ISystemRelOrgUserService systemRelOrgUserServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemRelOrgUser 人员组织关系系统对象
   * @return
   */
  @GetMapping("/systemrelorgusers" )
  public XfR getSystemRelOrgUsers(XfPage page, SystemRelOrgUser systemRelOrgUser) {
    return XfR.ok(systemRelOrgUserServiceImpl.page(page, Wrappers.query(systemRelOrgUser)));
  }

  /**
   * 通过id查询人员组织关系系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemrelorgusers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemRelOrgUserServiceImpl.getById(id));
  }

  /**
   * 新增人员组织关系系统对象
   * @param systemRelOrgUser 人员组织关系系统对象
   * @return XfR
   */
  @PostMapping("/systemrelorgusers")
  public XfR save(@RequestBody SystemRelOrgUser systemRelOrgUser) {
     return XfR.ok(systemRelOrgUserServiceImpl.save(systemRelOrgUser));
  }

  /**
   * 修改-传入修改后的全部数据人员组织关系系统对象
   * @param systemRelOrgUser 人员组织关系系统对象
   * @return XfR
   */
  @PutMapping("/systemrelorgusers/{id}")
  public XfR putUpdate(@RequestBody SystemRelOrgUser systemRelOrgUser,@PathVariable Long id) {
      systemRelOrgUser.setId(id);
      return XfR.ok(systemRelOrgUserServiceImpl.updateById(systemRelOrgUser));
  }

  /**
   * 修改-传入修改的数据人员组织关系系统对象
   * @param systemRelOrgUser 人员组织关系系统对象
   * @return XfR
   */
  @PatchMapping("/systemrelorgusers/{id}")
  public XfR patchUpdate(@RequestBody SystemRelOrgUser systemRelOrgUser,@PathVariable Long id) {
      SystemRelOrgUser upsystemRelOrgUser = systemRelOrgUserServiceImpl.getById(id);
      if(upsystemRelOrgUser != null){
        upsystemRelOrgUser = ObjectCopyUtils.copyProperties(systemRelOrgUser,upsystemRelOrgUser,true);
      }
      return XfR.ok(systemRelOrgUserServiceImpl.updateById(upsystemRelOrgUser));
  }

  /**
   * 通过id删除人员组织关系系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemrelorgusers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemRelOrgUserServiceImpl.removeById(id));
  }

  @PostMapping("/systemrelorgusers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_rel_org_user");
     params.put("request", condition);

     return XfR.ok(systemRelOrgUserServiceImpl.querys(params));
  }

}
