package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.TaxArchiveRecordFileBwcj;
import com.xforceplus.tocorder.service.ITaxArchiveRecordFileBwcjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 霸王茶姬档案文件信息前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class TaxArchiveRecordFileBwcjController {

  @Autowired
  private ITaxArchiveRecordFileBwcjService taxArchiveRecordFileBwcjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxArchiveRecordFileBwcj 霸王茶姬档案文件信息
   * @return
   */
  @GetMapping("/taxarchiverecordfilebwcjs" )
  public XfR getTaxArchiveRecordFileBwcjs(XfPage page, TaxArchiveRecordFileBwcj taxArchiveRecordFileBwcj) {
    return XfR.ok(taxArchiveRecordFileBwcjServiceImpl.page(page, Wrappers.query(taxArchiveRecordFileBwcj)));
  }

  /**
   * 通过id查询霸王茶姬档案文件信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxarchiverecordfilebwcjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxArchiveRecordFileBwcjServiceImpl.getById(id));
  }

  /**
   * 新增霸王茶姬档案文件信息
   * @param taxArchiveRecordFileBwcj 霸王茶姬档案文件信息
   * @return XfR
   */
  @PostMapping("/taxarchiverecordfilebwcjs")
  public XfR save(@RequestBody TaxArchiveRecordFileBwcj taxArchiveRecordFileBwcj) {
     return XfR.ok(taxArchiveRecordFileBwcjServiceImpl.save(taxArchiveRecordFileBwcj));
  }

  /**
   * 修改-传入修改后的全部数据霸王茶姬档案文件信息
   * @param taxArchiveRecordFileBwcj 霸王茶姬档案文件信息
   * @return XfR
   */
  @PutMapping("/taxarchiverecordfilebwcjs/{id}")
  public XfR putUpdate(@RequestBody TaxArchiveRecordFileBwcj taxArchiveRecordFileBwcj,@PathVariable Long id) {
      taxArchiveRecordFileBwcj.setId(id);
      return XfR.ok(taxArchiveRecordFileBwcjServiceImpl.updateById(taxArchiveRecordFileBwcj));
  }

  /**
   * 修改-传入修改的数据霸王茶姬档案文件信息
   * @param taxArchiveRecordFileBwcj 霸王茶姬档案文件信息
   * @return XfR
   */
  @PatchMapping("/taxarchiverecordfilebwcjs/{id}")
  public XfR patchUpdate(@RequestBody TaxArchiveRecordFileBwcj taxArchiveRecordFileBwcj,@PathVariable Long id) {
      TaxArchiveRecordFileBwcj uptaxArchiveRecordFileBwcj = taxArchiveRecordFileBwcjServiceImpl.getById(id);
      if(uptaxArchiveRecordFileBwcj != null){
        uptaxArchiveRecordFileBwcj = ObjectCopyUtils.copyProperties(taxArchiveRecordFileBwcj,uptaxArchiveRecordFileBwcj,true);
      }
      return XfR.ok(taxArchiveRecordFileBwcjServiceImpl.updateById(uptaxArchiveRecordFileBwcj));
  }

  /**
   * 通过id删除霸王茶姬档案文件信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxarchiverecordfilebwcjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxArchiveRecordFileBwcjServiceImpl.removeById(id));
  }

  @PostMapping("/taxarchiverecordfilebwcjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_archive_record_file_bwcj");
     params.put("request", condition);

     return XfR.ok(taxArchiveRecordFileBwcjServiceImpl.querys(params));
  }

}
