package com.xforceplus.tocorder.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.tocorder.entity.TaxElectronicArchiveBwcj;
import com.xforceplus.tocorder.service.ITaxElectronicArchiveBwcjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 霸王茶姬档案信息前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class TaxElectronicArchiveBwcjController {

  @Autowired
  private ITaxElectronicArchiveBwcjService taxElectronicArchiveBwcjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxElectronicArchiveBwcj 霸王茶姬档案信息
   * @return
   */
  @GetMapping("/taxelectronicarchivebwcjs" )
  public XfR getTaxElectronicArchiveBwcjs(XfPage page, TaxElectronicArchiveBwcj taxElectronicArchiveBwcj) {
    return XfR.ok(taxElectronicArchiveBwcjServiceImpl.page(page, Wrappers.query(taxElectronicArchiveBwcj)));
  }

  /**
   * 通过id查询霸王茶姬档案信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxelectronicarchivebwcjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxElectronicArchiveBwcjServiceImpl.getById(id));
  }

  /**
   * 新增霸王茶姬档案信息
   * @param taxElectronicArchiveBwcj 霸王茶姬档案信息
   * @return XfR
   */
  @PostMapping("/taxelectronicarchivebwcjs")
  public XfR save(@RequestBody TaxElectronicArchiveBwcj taxElectronicArchiveBwcj) {
     return XfR.ok(taxElectronicArchiveBwcjServiceImpl.save(taxElectronicArchiveBwcj));
  }

  /**
   * 修改-传入修改后的全部数据霸王茶姬档案信息
   * @param taxElectronicArchiveBwcj 霸王茶姬档案信息
   * @return XfR
   */
  @PutMapping("/taxelectronicarchivebwcjs/{id}")
  public XfR putUpdate(@RequestBody TaxElectronicArchiveBwcj taxElectronicArchiveBwcj,@PathVariable Long id) {
      taxElectronicArchiveBwcj.setId(id);
      return XfR.ok(taxElectronicArchiveBwcjServiceImpl.updateById(taxElectronicArchiveBwcj));
  }

  /**
   * 修改-传入修改的数据霸王茶姬档案信息
   * @param taxElectronicArchiveBwcj 霸王茶姬档案信息
   * @return XfR
   */
  @PatchMapping("/taxelectronicarchivebwcjs/{id}")
  public XfR patchUpdate(@RequestBody TaxElectronicArchiveBwcj taxElectronicArchiveBwcj,@PathVariable Long id) {
      TaxElectronicArchiveBwcj uptaxElectronicArchiveBwcj = taxElectronicArchiveBwcjServiceImpl.getById(id);
      if(uptaxElectronicArchiveBwcj != null){
        uptaxElectronicArchiveBwcj = ObjectCopyUtils.copyProperties(taxElectronicArchiveBwcj,uptaxElectronicArchiveBwcj,true);
      }
      return XfR.ok(taxElectronicArchiveBwcjServiceImpl.updateById(uptaxElectronicArchiveBwcj));
  }

  /**
   * 通过id删除霸王茶姬档案信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxelectronicarchivebwcjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxElectronicArchiveBwcjServiceImpl.removeById(id));
  }

  @PostMapping("/taxelectronicarchivebwcjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_electronic_archive_bwcj");
     params.put("request", condition);

     return XfR.ok(taxElectronicArchiveBwcjServiceImpl.querys(params));
  }

}
