/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.interceptor;

import com.xforceplus.tower.common.errorcode.BasicErrorCode;
import com.xforceplus.tower.common.response.Response;
import com.xforceplus.tower.utils.net.SendMsgUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ValidateUserCenterHandlerInterceptor
extends HandlerInterceptorAdapter {
    private Logger logger = LoggerFactory.getLogger(ValidateUserCenterHandlerInterceptor.class);
    @Value(value="${tower.validate.usercenter.allowedUrl:}")
    private String allowedUrl;
    @Value(value="${tower.validate.usercenter.enabled:true}")
    private Boolean validateEnabled;
    private static String[] userCenterHosts = new String[]{"tenant-gateway.41-tcenter-prod", "paas.xforceplus.com", "tenant-gateway.41-tenant-center", "tenant-gateway.41-tenant-sit", "paas-t.xforceplus.com", "paas-s.xforceplus.com", "ilife.xforceplus.com"};
    private static String[] ignorePath = new String[]{"/actuator", "/webjars", "/health", "/prometheus", "/api-docs", "/swagger", "/error", "favicon.ico"};

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.validateEnabled.booleanValue() || ValidateUserCenterHandlerInterceptor.validateUrl(request.getServletPath(), ignorePath).booleanValue() || ValidateUserCenterHandlerInterceptor.validateUrl(request.getServletPath(), this.allowedUrl.split(",")).booleanValue()) {
            return super.preHandle(request, response, handler);
        }
        String xForwardedHost = request.getHeader("X-Forwarded-Host");
        this.logger.info("request.getServletPath()==>{} xForwardedHost==>{}", (Object)request.getServletPath(), (Object)xForwardedHost);
        if (StringUtils.isBlank((String)xForwardedHost) || !ValidateUserCenterHandlerInterceptor.validateUrl(xForwardedHost, userCenterHosts).booleanValue()) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            Response returnResponse = new Response();
            returnResponse.setCode(BasicErrorCode.NotAuthError.getCode());
            returnResponse.setMessage(BasicErrorCode.NotAuthError.getMsg());
            SendMsgUtil.sendJsonMessage((HttpServletResponse)response, returnResponse);
            return false;
        }
        return super.preHandle(request, response, handler);
    }

    private static Boolean validateUrl(String path, String[] allowedUrls) {
        if (allowedUrls.length <= 0) {
            return false;
        }
        for (String url : allowedUrls) {
            if (StringUtils.isBlank((String)url) || !path.toLowerCase().contains(url.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(ValidateUserCenterHandlerInterceptor.validateUrl("/swagger-ui.html", ignorePath));
    }
}

