/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import com.xforceplus.tower.common.errorcode.BasicErrorCode;
import com.xforceplus.tower.common.response.Response;

/**
 * 统一拦截参数异常
 * 
 * @ClassName: ExceptionAdvice.
 * @Description:
 * @author zhaochao
 * @date 2019年10月9日 下午3:43:05
 * @ControllerAdvice 由于每个服务返回不一致，暂不启用
 */
public class ExceptionAdvice {
	Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);

	@ExceptionHandler(BindException.class)
	@ResponseBody
	public Response handlerBindException(BindException ex) {

		logger.error("系统异常", ex);
		StringBuilder strBuilder = new StringBuilder();
		List<FieldError> errors = ex.getBindingResult().getFieldErrors();
		for (FieldError fieldError : errors) {
			strBuilder.append(fieldError.getField() + fieldError.getDefaultMessage() + ",");
		}
		strBuilder.deleteCharAt(strBuilder.length() - 1);
		logger.error(String.format("参数检验异常:%s", strBuilder.toString()), ex);
		return Response.fail(BasicErrorCode.ParameterError, strBuilder.toString());
	}

	@ExceptionHandler(Exception.class)
	@ResponseBody
	public Response handleException(Exception ex) {
		logger.error("系统异常", ex);

		if (ex instanceof TowerException) {
			// 支持返回body体,by chao-zh
			return null == ((TowerException) ex).getObject() ? Response.fail(((TowerException) ex).getErrorCode())
					: Response.fail(((TowerException) ex).getErrorCode(), ((TowerException) ex).getObject());
		} else if (ex instanceof TowerOfMsgException) {
			// 支持返回自定义错误信息,by chao-zh
			return null == ((TowerOfMsgException) ex).getMsg()
					? Response.fail(((TowerOfMsgException) ex).getErrorCode())
					: Response.failOfMsg(((TowerOfMsgException) ex).getErrorCode(),
							((TowerOfMsgException) ex).getMsg());
		} else {
			return Response.fail();
		}

	}
}
