/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common;

import com.xforceplus.tower.common.errorcode.TowerErrorCode;

/**
 * 将自定义异常信息放入response.msg中
 * 
 * @ClassName: towerOfMsgException.
 * @Description: TODO
 * @author zhaochao
 * @date 2019年5月16日 下午8:12:17
 *
 */
public class TowerOfMsgException extends RuntimeException {

	/**
	 * @Fields serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	private TowerErrorCode errorCode;

	private String msg;

	public TowerOfMsgException(TowerErrorCode errorCode) {
		super(errorCode.getMsg());
		this.errorCode = errorCode;
	}

	public TowerOfMsgException(TowerErrorCode errorCode, String msg) {
		super(errorCode.getMsg());
		this.errorCode = errorCode;
		this.msg = msg;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public TowerErrorCode getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(TowerErrorCode errorCode) {
		this.errorCode = errorCode;
	}
}
