/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import com.xforceplus.tower.common.token.UserCenter;

import feign.RequestInterceptor;
import feign.RequestTemplate;

/**
 * 统一FeginClient调用时增加token
 * 
 * @ClassName: FeginClientConfig.
 * @Description: TODO
 * @author zhaochao
 * @category 2019年10月27日 下午8:00:04
 *
 */
@Component
public class FeginClientConfig {

	@Autowired
	private UserCenter userCenter;
	
	@Value("${tower.userCenter.getToken.enabled:true}")
	private Boolean getTokenEnabled;

	@Bean
	public RequestInterceptor headerInterceptor() {
		return new RequestInterceptor() {
			@Override
			public void apply(RequestTemplate requestTemplate) {

				if(getTokenEnabled) {
					requestTemplate.header("x-app-token", userCenter.getToken());
				}
			}
		};
	}

}