package com.xforceplus.tower.common.configuration;

import java.util.ArrayList;
import java.util.Collections;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import com.xforceplus.tower.common.interceptor.CommonCustomMetricsInterceptor;
import com.xforceplus.tower.common.interceptor.ValidateUserCenterHandlerInterceptor;

import io.prometheus.client.Counter;

@Configuration
@Primary
/**
 * 调用用户中心token
 * 
 * @ClassName: ValidateUserCenterConfiguration.
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月2日 下午2:44:55
 * @ConditionalOnProperty(name = "tower.validate.usercenter.enabled",havingValue
 *                             = "true")
 */
public class ValidateUserCenterConfiguration implements WebMvcConfigurer {

	@Override
	public void addInterceptors(InterceptorRegistry registry) {

		registry.addInterceptor(getValidateUserCenterHandlerInterceptor()).

				addPathPatterns(getIncludePathPatterns());
		
		registry.addInterceptor(getPrometheusMetricsInterceptor()).

		addPathPatterns(getIncludePathPatterns());

	}

	@Bean
	ValidateUserCenterHandlerInterceptor getValidateUserCenterHandlerInterceptor() {

		return new ValidateUserCenterHandlerInterceptor();

	}

	@Bean
	CommonCustomMetricsInterceptor getPrometheusMetricsInterceptor() {

		return new CommonCustomMetricsInterceptor();

	}
	
	/**
	 * 需要用户和服务认证判断的路径
	 * 
	 * @return
	 */
	private ArrayList getIncludePathPatterns() {

		ArrayList list = new ArrayList<>();
		String[] urls = { "/**" };
		Collections.addAll(list, urls);
		return list;

	}

}