/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common.errorcode;

/**
 * 基础异常编码
 * 
 * @ClassName: BasicErrorCode.
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月2日 下午2:33:48
 *
 */
public enum BasicErrorCode implements TowerErrorCode {

	/**
	 * 系统错误
	 */
	SystemError(100001, "系统错误"),
	/**
	 * 未通过用户中心网关调用错误
	 */
	NotAuthError(100401, "未通过用户中心网关调用错误"),
	/**
	 * 请求参数错误
	 */
	ParameterError(100403, "请求参数错误");

	/**
	 * 返回编码
	 */
	private int code;
	/**
	 * 返回信息
	 */
	private String msg;

	BasicErrorCode(int code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	@Override
	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	@Override
	public String getMsg() {
		return msg;
	}

	public static TowerErrorCode get(int code) {
		for (BasicErrorCode i : BasicErrorCode.values()) {
			if (i.getCode() == code) {
				return i;
			}
		}
		return BasicErrorCode.SystemError;
	}

	public TowerErrorCode valueOf(int code) {
		return get(code);
	}
}
