/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common.interceptor;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
/**
 * 公共自定義指標
 * @author zhaochao
 * @since 2019-11-4 19:22:27
 *
 */
public class CommonCustomMetricsInterceptor extends HandlerInterceptorAdapter {

	AtomicInteger atomicInteger = new AtomicInteger(37);
	/**
	 * 租戶Id
	 */
	private static final String APP_ID = "appId";

	/**
	 * 產品線id
	 */
	private static final String TENANT_ID = "tenantId";

	@RequestMapping(value = "/{tenantId}")
	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
			throws Exception {
		String requestUri = request.getRequestURI();
		String method = request.getMethod();
		int status = response.getStatus();

		NativeWebRequest webRequest = new ServletWebRequest(request);
		Map<String, String> map = (Map<String, String>) webRequest
				.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, RequestAttributes.SCOPE_REQUEST);

		String appId = StringUtils.isBlank(request.getParameter(APP_ID)) ? StringUtils.EMPTY
				: request.getParameter(APP_ID);

		String tenantId = null == map || StringUtils.isBlank(map.get(TENANT_ID)) ? StringUtils.EMPTY : map.get(TENANT_ID);

		Counter requestCounter = Metrics.counter("tower.custom.common.http.requests.total", APP_ID, appId, TENANT_ID,
				tenantId, "path", requestUri, "method", method, "status", String.valueOf(status));
		requestCounter.increment();

		super.afterCompletion(request, response, handler, ex);
	}
}