package com.xforceplus.tower.common.track.config;

import java.util.Iterator;
import java.util.ServiceLoader;
/**
 * 链路追踪
 * @ClassName: XplatServiceBootstrap. 
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月4日 下午8:51:55 
 *
 */
public class XplatServiceBootstrap {
	public XplatServiceBootstrap() {
	}

	public static <S> S loadFirst(Class<S> clazz) {
		Iterator<S> iterator = loadAll(clazz);
		if (!iterator.hasNext()) {
			throw new IllegalStateException(String.format(
					"No implementation defined in /META-INF/services/%s, please check whether the file exists and has the right implementation class!",
					clazz.getName()));
		} else {
			return iterator.next();
		}
	}

	private static <S> Iterator<S> loadAll(Class<S> clazz) {
		ServiceLoader<S> loader = ServiceLoader.load(clazz);
		return loader.iterator();
	}
}