package com.xforceplus.tower.common.track.properties.provider.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xforceplus.tower.common.track.io.UnicodeInputStream;
import com.xforceplus.tower.common.track.properties.provider.XplatAppVersionProvider;
import com.xforceplus.tower.common.track.properties.provider.XplatProvider;
import com.xforceplus.tower.common.utils.Utils;
/**
 * 链路追踪
 * @ClassName: DefaultXplatAppVersionProvider. 
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月4日 下午8:54:46 
 *
 */
public class DefaultXplatAppVersionProvider implements XplatAppVersionProvider {
	private static final Logger logger = LoggerFactory.getLogger(DefaultXplatAppVersionProvider.class);
	public static final String APP_PROPERTIES_CLASSPATH = "META-INF/app-version.properties";/// META-INF/MANIFEST.MF";//
	public static final String PROPERTIES_KEY = "app.version";
	private Properties mAppProperties = new Properties();
	private String mAppVersion;

	public DefaultXplatAppVersionProvider() {
	}

	@Override
	public void initialize() {
		try {
			InputStream in = Thread.currentThread().getContextClassLoader()
					.getResourceAsStream(APP_PROPERTIES_CLASSPATH);
			if (in == null) {
				in = DefaultXplatAppVersionProvider.class.getResourceAsStream(APP_PROPERTIES_CLASSPATH);
			}
			if (in == null) {
				logger.warn("{} not found from classpath!", APP_PROPERTIES_CLASSPATH);
			}
			this.initialize(in);
		} catch (Throwable var2) {
			logger.error("Initialize DefaultApplicationProvider failed.", var2);
		}

	}

	@Override
	public void initialize(InputStream in) {
		try {
			if (in != null) {
				try {
					this.mAppProperties
							.load(new InputStreamReader(new UnicodeInputStream(in, "utf-8"), StandardCharsets.UTF_8));
				} finally {
					in.close();
				}
			}

			this.initAppVersion();
		} catch (Throwable var6) {
			logger.error("Initialize DefaultApplicationProvider failed.", var6);
		}

	}

	@Override
	public String getAppVersion() {
		return this.mAppVersion;
	}

	@Override
	public boolean isAppVersionSet() {
		return !Utils.isBlank(this.mAppVersion);
	}

	@Override
	public String getProperty(String name, String defaultValue) {
		String val;
		if (PROPERTIES_KEY.equals(name)) {
			val = this.getAppVersion();
			return val == null ? defaultValue : val;
		} else {
			val = this.mAppProperties.getProperty(name, defaultValue);
			return val == null ? defaultValue : val;
		}
	}

	@Override
	public Class<? extends XplatProvider> getType() {
		return XplatAppVersionProvider.class;
	}

	private void initAppVersion() {
		this.mAppVersion = System.getProperty(PROPERTIES_KEY);
		if (!Utils.isBlank(this.mAppVersion)) {
			this.mAppVersion = this.mAppVersion.trim();
			logger.info("App Version is set to {} by app.version property from System Property", this.mAppVersion);
		} else {
			this.mAppVersion = this.mAppProperties.getProperty(PROPERTIES_KEY);
			if (!Utils.isBlank(this.mAppVersion)) {
				this.mAppVersion = this.mAppVersion.trim();
				logger.info("App Version is set to {} by app.version property from {}", this.mAppVersion,
						APP_PROPERTIES_CLASSPATH);
			} else {
				this.mAppVersion = null;
				logger.warn("app.version is not available from System Property and {}. It is set to null",
						APP_PROPERTIES_CLASSPATH);
			}
		}
	}

	@Override
	public String toString() {
		return "appVersion [" + this.getAppVersion() + "] properties: " + this.mAppProperties
				+ " (DefaultApplicationProvider)";
	}
}
