/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common;

import com.xforceplus.tower.common.TowerException;
import com.xforceplus.tower.common.TowerOfMsgException;
import com.xforceplus.tower.common.errorcode.BasicErrorCode;
import com.xforceplus.tower.common.response.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public class ExceptionAdvice {
    Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public Response handlerBindException(BindException ex) {
        this.logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)ex);
        StringBuilder strBuilder = new StringBuilder();
        List errors = ex.getBindingResult().getFieldErrors();
        for (FieldError fieldError : errors) {
            strBuilder.append(String.valueOf(fieldError.getField()) + fieldError.getDefaultMessage() + ",");
        }
        strBuilder.deleteCharAt(strBuilder.length() - 1);
        this.logger.error(String.format("\u53c2\u6570\u68c0\u9a8c\u5f02\u5e38:%s", strBuilder.toString()), (Throwable)ex);
        return Response.fail(BasicErrorCode.ParameterError, strBuilder.toString());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Response handleException(Exception ex) {
        this.logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)ex);
        if (ex instanceof TowerException) {
            return ((TowerException)ex).getObject() == null ? Response.fail(((TowerException)ex).getErrorCode()) : Response.fail(((TowerException)ex).getErrorCode(), ((TowerException)ex).getObject());
        }
        if (ex instanceof TowerOfMsgException) {
            return ((TowerOfMsgException)ex).getMsg() == null ? Response.fail(((TowerOfMsgException)ex).getErrorCode()) : Response.failOfMsg(((TowerOfMsgException)ex).getErrorCode(), ((TowerOfMsgException)ex).getMsg());
        }
        return Response.fail();
    }
}

